<?php session_start();
require_once 'config.php';
$PageName = "My Expenses";
$Page = "Recharge";
$WallMsg = "NotShow"; 
$url = "home.php";?>
<!doctype html>
<html lang="en" class="h-100">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <meta name="generator" content="">
    <title><?php echo $Proj_Title; ?></title>

    <!-- manifest meta -->
    <meta name="apple-mobile-web-app-capable" content="yes">

    <!-- Favicons -->
    <link rel="apple-touch-icon" href="img/favicon180.png" sizes="180x180">
    <link rel="icon" href="img/favicon32.png" sizes="32x32" type="image/png">
    <link rel="icon" href="img/favicon16.png" sizes="16x16" type="image/png">

    <!-- Material icons-->
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">

    <!-- Google fonts-->
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500&amp;display=swap" rel="stylesheet">

    <!-- swiper CSS -->
    <link href="vendor/swiper/css/swiper.min.css" rel="stylesheet">

    <!-- Custom styles for this template -->
    <link href="css/style.css" rel="stylesheet" id="style">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
            <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert-dev.js"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.css">
</head>

<body class="body-scroll d-flex flex-column h-100 menu-overlay">
   


    <!-- Begin page content -->
    <?php include 'sidebar.php';?>
    <div class="backdrop"></div>


    <!-- Begin page content -->
    <main class="flex-shrink-0 main has-footer">
        <!-- Fixed navbar -->
       
<?php include 'top_header.php';?>

        <!-- page content start -->


  
        <div class="main-container">
            <div class="container">
                
               
               

                      <style>
    .product-card {
        font-family: 'Segoe UI', sans-serif;
        font-size: 14px;
        line-height: 1.6;
    }
    .product-card h5 {
        font-weight: 600;
        color: #000;
        margin-bottom: 8px;
    }
    .product-card .label {
        color: #333;
        font-weight: 500;
    }
    .product-card .value {
        font-weight: 600;
        margin-left: 4px;
    }
    .product-card .status-approved {
        color: green;
    }
    .product-card .status-rejected {
        color: red;
    }
    .product-card .status-pending {
        color: orange;
    }
</style>

<?php 
$id = $_GET['id'];
$sql = "SELECT ts.*, p.ProductName, p.MinQty 
        FROM tbl_fr_req_prod_stock ts 
        INNER JOIN tbl_cust_products_2025 p ON ts.ProdId = p.id 
        WHERE ts.InvId = '$id'";
$rows = getList($sql);
?>

<form method="post" action="accept_franchise_stock.php">
<?php
if (!empty($rows)) {
    $allAccepted = true; // assume all accepted initially

    foreach($rows as $result){
        $status = $result['PurchaseStatus'];
        $statusDate = !empty($result['StockDate']) ? date("d/m/Y", strtotime($result['StockDate'])) : "-";
        $statusComment = $result['PurchaseComment'];
        $approveqty = $result['PurchaseQty'];

        // Status text and color
        $statusText = "Pending";
        $statusClass = "text-warning font-weight-bold";

        if ($status == '1') {
            $statusText = "Accepted";
            $statusClass = "text-success font-weight-bold";
        } elseif ($status == '2') {
            $statusText = "Rejected";
            $statusClass = "text-danger font-weight-bold";
            $allAccepted = false;
        } else {
            $allAccepted = false;
        }
?>
    <div class="card mb-3 product-card shadow-sm" 
         style="<?php echo ($statusText == 'Accepted') ? 'background-color:#d4edda;' : ''; ?>">
        <div class="card-body">
            <div class="row align-items-center">
                <div class="col">
                    <h5><?php echo htmlspecialchars($result['ProductName']); ?></h5>

                    <div>
                        <span class="label">Request Date:</span>
                        <span class="value"><?php echo $statusDate; ?></span>
                    </div>

                    <div>
                        <span class="label">Requested Qty:</span>
                        <span class="value"><?php echo htmlspecialchars($result['Qty']); ?></span>
                    </div>

                    <div>
                        <span class="label">Approved Qty:</span>
                        <span class="value"><?php echo $approveqty ?: '-'; ?></span>
                    </div>

                    <div>
                        <span class="label">Distributor Status:</span>
                        <span class="<?php echo $statusClass; ?>"><?php echo $statusText; ?></span>
                    </div>
                </div>

                <?php 
                // Show checkbox only if Accepted (status=1) AND not yet accepted by franchise (AcceptByFr != 1)
                if ($status == 1 && $result['AcceptByFr'] != '1') { ?>
                <div class="col-auto">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" 
                               name="selected_ids[]" 
                               value="<?php echo $result['id']; ?>" 
                               id="chk_<?php echo $result['id']; ?>">
                        <label class="form-check-label" for="chk_<?php echo $result['id']; ?>">
                            
                        </label>
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>
<?php
    }

    // Show button only if at least one is not accepted
    if (!$allAccepted) {
        echo '<button type="submit" class="btn btn-default mt-3">Selected Stock Accept</button>';
    }
} else {
    echo '<p class="text-muted">No records found.</p>';
}
?>
</form>



                        
                       

            </div>
        </div>
    </main>

<?php include 'footer.php';?>
  <?php include 'inc-fr-lists.php';include 'inc-calendar-lists.php';?>
    <!-- Required jquery and libraries -->
    <script src="js/jquery-3.3.1.min.js"></script>
    <script src="js/popper.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.min.js"></script>

    <!-- cookie js -->
    <script src="js/jquery.cookie.js"></script>

    <!-- Swiper slider  js-->
    <script src="vendor/swiper/js/swiper.min.js"></script>

    <!-- Customized jquery file  -->
    <script src="js/main.js"></script>
    <script src="js/color-scheme-demo.js"></script>


    <!-- page level custom script -->
    <script src="js/app.js"></script>
<script>
    function getExpId(id){
        $('#myModal').modal('show');
        $('.Exp_Id').val(id);
    }
</script>
   
</body>

</html>
