<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class RiderLocationUpdateRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'latitude' => ['required', 'numeric', 'between:-90,90'],
            'longitude' => ['required', 'numeric', 'between:-180,180'],
            'is_online' => ['nullable', 'boolean'],
            'is_available' => ['nullable', 'boolean'],
        ];
    }

    public function messages(): array
    {
        return [
            'latitude.required' => __('The latitude field is required.'),
            'latitude.numeric' => __('Latitude must be a number.'),
            'latitude.between' => __('Latitude must be between -90 and 90 degrees.'),
            'longitude.required' => __('The longitude field is required.'),
            'longitude.numeric' => __('Longitude must be a number.'),
            'longitude.between' => __('Longitude must be between -180 and 180 degrees.'),
        ];
    }
}

