<?php

use App\Models\Driver;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table((new Driver)->getTable(), function (Blueprint $table) {
            $table->decimal('current_latitude', 10, 7)->nullable()->after('user_id');
            $table->decimal('current_longitude', 10, 7)->nullable()->after('current_latitude');
            $table->boolean('is_online')->default(false)->after('current_longitude');
            $table->boolean('is_available')->default(true)->after('is_online');
            $table->timestamp('location_updated_at')->nullable()->after('is_available');
        });
    }

    public function down(): void
    {
        Schema::table((new Driver)->getTable(), function (Blueprint $table) {
            $table->dropColumn([
                'current_latitude',
                'current_longitude',
                'is_online',
                'is_available',
                'location_updated_at',
            ]);
        });
    }
};

