<?php $__env->startSection('header-title', __('Order Details')); ?>

<?php $__env->startSection('content'); ?>

    <div class="row my-3">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header d-flex align-items-center justify-content-between gap-2 py-3">
                    <h4 class="card-title mb-0"><?php echo e(__('Order Details')); ?></h4>
                    <div class="d-flex gap-2 flex-wrap">
                        <a href="<?php echo e(route('shop.payment-slip', $order->id)); ?>" target="_blank" class="btn btn-success py-2.5">
                            <img src="<?php echo e(asset('assets/icons-admin/download-alt.svg')); ?>" alt="icon" loading="lazy"
                                width="20" />
                            <?php echo e(__('Payment Slip')); ?>

                        </a>
                        <a href="<?php echo e(route('shop.download-invoice', $order->id)); ?>" target="_blank" class="btn btn-primary py-2.5">
                            <img src="<?php echo e(asset('assets/icons-admin/download-alt.svg')); ?>" alt="icon" loading="lazy"
                                width="20" />
                            <?php echo e(__('Download Invoice')); ?>

                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="d-flex gap-3 flex-wrap align-items-center">
                        <div class="flex-grow-1">
                            <div class="order-item">
                                <label class="label"><?php echo e(__('Order Id')); ?>:</label>
                                <span class="value">#<?php echo e($order->prefix . $order->order_code); ?></span>
                            </div>
                            <div class="order-item">
                                <label class="label"><?php echo e(__('Payment Status')); ?>:</label>
                                <span class="value"><?php echo e($order->payment_status); ?></span>
                            </div>
                            <div class="order-item">
                                <label class="label"><?php echo e(__('Payment Method')); ?>:</label>
                                <span class="value"><?php echo e($order->payment_method); ?></span>
                            </div>
                        </div>

                        <div class="item-divider"></div>

                        <div class="flex-grow-1">
                            <div class="order-item">
                                <label class="label"><?php echo e(__('Order Status')); ?>:</label>
                                <span class="value"><?php echo e($order->order_status); ?></span>
                            </div>
                            <div class="order-item">
                                <label class="label"><?php echo e(__('Order Date')); ?>:</label>
                                <span class="value"><?php echo e($order->created_at->format('M d, Y')); ?></span>
                            </div>
                            <div class="order-item">
                                <label class="label"><?php echo e(__('Delivery Date')); ?>:</label>
                                <span
                                    class="value"><?php echo e($order->delivery_date ? Carbon\Carbon::parse($order->delivery_date)->format('M d, Y') : '-'); ?></span>
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive mt-4 mb-0">
                        <table class="table border-left-right">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('SL')); ?></th>
                                    <th><?php echo e(__('Product')); ?></th>
                                    <?php if($businessModel == 'multi'): ?>
                                        <th><?php echo e(__('Shop')); ?></th>
                                    <?php endif; ?>
                                    <th><?php echo e(__('Quantity')); ?></th>
                                    <th><?php echo e(__('Size')); ?></th>
                                    <th><?php echo e(__('Color')); ?></th>
                                    <th><?php echo e(__('Price')); ?></th>
                                    <th class="text-end"><?php echo e(__('Total')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $order->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($key + 1); ?></td>
                                        <td>
                                            <div class="d-flex gap-1 align-items-center">
                                                <img src="<?php echo e($product->thumbnail); ?>" alt="" width="40"
                                                    height="40" loading="lazy">
                                                <span><?php echo e($product->name); ?></span>
                                            </div>
                                        </td>
                                        <?php if($businessModel == 'multi'): ?>
                                            <td><?php echo e($product->shop?->name); ?></td>
                                        <?php endif; ?>
                                        <td><?php echo e($product->pivot->quantity); ?></td>
                                        <td><?php echo e($product->pivot->size ?? '-'); ?></td>
                                        <td><?php echo e($product->pivot->color ?? '-'); ?></td>
                                        <td>
                                            <?php
                                                $price =
                                                    $product->pivot->price > 0
                                                        ? $product->pivot->price
                                                        : ($product->discount_price > 0
                                                            ? $product->discount_price
                                                            : $product->price);
                                            ?>
                                            <?php echo e(showCurrency($price)); ?>

                                        </td>
                                        <td class="text-end">
                                            <?php echo e(showCurrency($product->pivot->quantity * $price)); ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="max-300 ms-auto d-flex flex-column gap-1">
                        <div class="d-flex align-items-center justify-content-between gap-2">
                            <div><?php echo e(__('Sub Total')); ?></div>
                            <div><?php echo e(showCurrency($order->total_amount)); ?></div>
                        </div>

                        <div class="d-flex align-items-center justify-content-between gap-2">
                            <div><?php echo e(__('Coupon Discount')); ?></div>
                            <div><?php echo e(showCurrency($order->coupon_discount)); ?></div>
                        </div>

                        <div class="d-flex align-items-center justify-content-between gap-2">
                            <div><?php echo e(__('Delivery Charge')); ?></div>
                            <div><?php echo e(showCurrency($order->delivery_charge)); ?></div>
                        </div>

                        <div class="d-flex align-items-center justify-content-between gap-2">
                            <div><?php echo e(__('VAT & Tax')); ?></div>
                            <div><?php echo e(showCurrency($order->tax_amount)); ?></div>
                        </div>

                        <div class="d-flex align-items-center justify-content-between gap-2 border-top pt-1 mt-1">
                            <div class="fw-bold"><?php echo e(__('Grand Total')); ?></div>
                            <div class="fw-bold"><?php echo e(showCurrency($order->payable_amount)); ?></div>
                        </div>
                    </div>
                </div>
            </div>

            <!--##### Customer Info #####-->
            <div class="mt-3 card">
                <h5 class="fz-16 border-bottom px-3 py-12 m-0"><?php echo e(__('Customer Info')); ?></h5>

                <div class="border-bottom px-3 py-2 d-flex  align-items-center gap-3">
                    <span class="text-color"><?php echo e(__('Name')); ?>: </span>
                    <span class="fw-medium"><?php echo e($order->customer?->user?->name); ?></span>
                </div>
                <div class="px-3 py-2 d-flex  align-items-center gap-3">
                    <span class="text-color"><?php echo e(__('Phone')); ?>: </span>
                    <span class="fw-medium"><?php echo e($order->customer?->user?->phone); ?></span>
                </div>
            </div>

        </div>

        <div class="col-lg-4">
            <!--##### Order & Shipping Info #####-->
            <div class="card">
                <h5 class="fz-18 border-bottom p-3 m-0"><?php echo e(__('Order & Shipping Info')); ?></h5>

                <div class="px-3 py-2 d-flex justify-content-between align-items-center flex-wrap gap-2 border-bottom">
                    <div class="text-color"><?php echo e(__('Change Order Status')); ?></div>
                    <div class="dropdown">
                        <a class="btn border text-start dropdown-toggle" href="#" role="button"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            <?php echo e($order->order_status->value); ?>

                        </a>
                        <?php if($order->order_status->value != 'Delivered' && $order->order_status->value != 'Cancelled'): ?>
                            <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', ['admin.order.status.change'])): ?>
                                <ul class="dropdown-menu order-status">
                                    <?php $__currentLoopData = $orderStatus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <a class="dropdown-item <?php if(in_array($status->value, ['Delivered','Cancelled'])): ?> OrderStatusConfirm <?php endif; ?>"
                                                href="<?php echo e(route('admin.order.status.change', $order->id)); ?>?status=<?php echo e($status->value); ?>">
                                                <?php echo e(__($status->value)); ?>

                                            </a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php endif; ?>
                         <?php endif; ?>
                    </div>
                </div>

                <div class="border-bottom d-flex justify-content-between align-items-center flex-wrap gap-2 p-3">
                    <div class="text-color"><?php echo e(__('Payment Status')); ?></div>
                    <div class="d-flex align-items-center gap-1">
                        <span><?php echo e($order->payment_status); ?></span>
                        <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.order.payment.status.toggle')): ?>
                            <label class="switch mb-0">
                                <a href="<?php echo e(route('admin.order.payment.status.toggle', $order->id)); ?>">
                                    <input type="checkbox" <?php echo e($order->payment_status->value == 'Paid' ? 'checked' : ''); ?>>
                                    <span class="slider round"></span>
                                </a>
                            </label>
                        <?php endif; ?>
                    </div>
                </div>

                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.rider.assign.order')): ?>
                    <?php if($order->order_status->value != 'Pending'): ?>
                        <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 p-3">
                            <div class="fw-medium text-color"><?php echo e(__('Assign Rider')); ?></div>
                            <div class="d-flex align-items-center gap-1">

                                <?php if($order->driverOrder): ?>
                                    <span><?php echo e($order->driverOrder->driver?->user?->fullName); ?></span>
                                <?php else: ?>
                                    <button class="btn btn-outline-primary" data-bs-toggle="modal"
                                        data-bs-target="#assignRider">
                                        <img src="<?php echo e(asset('assets/icons-admin/truck-fill.svg')); ?>" alt="icon"
                                            loading="lazy" />
                                        <?php echo e(__('Assign')); ?>

                                    </button>
                                <?php endif; ?>

                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>

            <!--##### Shipping Address #####-->
            <div class="card mt-3">
                <h5 class="fz-18 border-bottom p-3 m-0"><?php echo e(__('Shipping Address')); ?></h5>

                <div class="border-bottom d-flex align-items-center justify-content-between gap-2 px-3 py-12">
                    <span class="text-color"><?php echo e(__('Name')); ?>: </span>
                    <span class="fw-medium"><?php echo e($order->address?->name); ?></span>
                </div>
                <div class="border-bottom d-flex align-items-center justify-content-between gap-2 px-3 py-12">
                    <span class="text-color"><?php echo e(__('Phone')); ?>: </span>
                    <span class="fw-medium"><?php echo e($order->address?->phone); ?></span>
                </div>
                <div class="border-bottom d-flex align-items-center justify-content-between gap-2 px-3 py-12">
                    <span class="text-color"><?php echo e(__('Address Type')); ?>: </span>
                    <span class="fw-medium"><?php echo e($order->address?->address_type); ?></span>
                </div>
                <div class="border-bottom d-flex align-items-center justify-content-between gap-2 px-3 py-12">
                    <span class="text-color"><?php echo e(__('Area')); ?>: </span>
                    <span class="fw-medium"><?php echo e($order->address?->area); ?></span>
                </div>
                <div class="d-flex gap-2 border-bottom align-items-center justify-content-between flex-wrap px-3 py-12">
                    <div>
                        <span class="text-color"><?php echo e(__('Road No')); ?>: </span>
                        <span class="fw-medium"><?php echo e($order->address?->road_no); ?></span>,
                    </div>
                    <div>
                        <span class="text-color"><?php echo e(__('Flat No')); ?>: </span>
                        <span class="fw-medium"><?php echo e($order->address?->flat_no); ?></span>,
                    </div>
                    <div>
                        <span class="text-color"><?php echo e(__('House No')); ?>: </span>
                        <span class="fw-medium"><?php echo e($order->address?->house_no); ?></span>
                    </div>
                </div>

                <div class="border-bottom d-flex align-items-center justify-content-between gap-2 px-3 py-12">
                    <span class="text-color"><?php echo e(__('Post Code')); ?>: </span>
                    <span class="fw-medium"><?php echo e($order->address?->post_code); ?></span>
                </div>
                <div class="border-bottom d-flex align-items-center justify-content-between gap-2 px-3 py-12">
                    <span class="text-color"><?php echo e(__('Address Line')); ?>: </span>
                    <span class="fw-medium"><?php echo e($order->address?->address_line); ?></span>
                </div>
                <div class="d-flex align-items-center justify-content-between gap-2 px-3 py-12">
                    <span class="text-color"><?php echo e(__('Address Line')); ?> 2: </span>
                    <span class="fw-medium"><?php echo e($order->address?->address_line2); ?></span>
                </div>
            </div>

        </div>
    </div>

    <!-- Assign Rider Modal -->
    <form action="<?php echo e(route('admin.rider.assign.order', $order->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="modal fade" id="assignRider">
            <div class="modal-dialog modal-dialog-centered modal-lg modal-dialog-scrollable">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3 class="modal-title fs-5"><?php echo e(__('Select a rider')); ?></h3>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="d-flex gap-2 flex-column">
                            <?php $__currentLoopData = $riders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="w-100">
                                    <input type="radio" name="rider" value="<?php echo e($rider->id); ?>"
                                        id="rider<?php echo e($rider->id); ?>" class="btn-check">
                                    <label for="rider<?php echo e($rider->id); ?>" class="btn riderSelectBtn">
                                        <div>
                                            <img src="<?php echo e($rider->user->thumbnail); ?>" alt="profile"
                                                class="profilePhoto" />
                                            <span class="riderName">
                                                <?php echo e($rider->user->fullName); ?>

                                            </span>
                                        </div>
                                        <div class="d-flex gap-1 align-items-center">
                                            <span class="text-muted inCompleted">
                                                <?php echo e(__('Incomplete Orders')); ?>:
                                            </span>
                                            <span class="totalOrders"><?php echo e($rider->incompleteOrders()->count()); ?></span>
                                        </div>

                                    </label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">
                            <?php echo e(__('Assign Now')); ?>

                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('css'); ?>
    <style>
        .dropdown-menu.order-status {
            min-width: 200px;
            padding: 8px;
            border: 1px solid #e5e5e5;
            box-shadow: 0 0 10px #e5e5e5;
        }

        .dropdown-menu.order-status .dropdown-item {
            border-bottom: 1px solid #f1f1f1;
        }

        .app-theme-dark .dropdown-menu.order-status {
            border: 1px solid #343a40;
            box-shadow: 0 0 10px #343a40;
        }
        .app-theme-dark .dropdown-menu.order-status .dropdown-item {
            border-bottom: 1px solid #343a40;
        }

        .max-300 {
            max-width: 340px;
        }

        .min-w-200 {
            min-width: 200px;
            display: inline;
        }

        .item-divider {
            height: 80px;
            width: 1px;
            background: #e5e5e5;
            margin: 0 20px;
        }

        .app-theme-dark .item-divider {
            background: #343a40;
        }

        .order-item {
            display: flex;
            gap: 10px;
            align-items: center;
            justify-content: space-between;
            font-size: 14px;
            margin-bottom: 10px;
        }

        .order-item:last-child {
            margin-bottom: 0;
        }

        .order-item .label {
            color: #687387;
            line-height: 22px;
        }

       .app-theme-dark .order-item .label {
            color: #8f96a6;
        }

        .order-item .value {
            line-height: 22px;
            font-weight: 500;
            color: #000;
        }

        .app-theme-dark .order-item .value {
            color: #fff;
        }

        @media (max-width: 768px) {
            .item-divider {
                display: none;
            }
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function () {
    $(".dropdown-menu").on("click", ".OrderStatusConfirm", function (e) {
        e.preventDefault();
        e.stopImmediatePropagation();

        const url = $(this).attr("href");
        const statusName = $(this).text().trim();

        Swal.fire({
            title: "Are you sure?",
            text: `Do you really want to mark this order as ${statusName}?`,
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, proceed!"
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = url;
            }
        });
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home4/righthir/righthire.co.in/resources/views/admin/order/show.blade.php ENDPATH**/ ?>