<?php $__env->startSection('header-title', __('Orders')); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <ul class="nav nav-tabs">
            <?php
                use App\Enums\OrderStatus;
                $orderStatuses = OrderStatus::cases();
            ?>


                    <li class="nav-item">
                        <a href="<?php echo e(route('admin.order.index')); ?>"
                        class="nav-link <?php echo e(request()->url() === route('admin.order.index') ? 'active' : ''); ?>">
                        <?php echo e(__('All')); ?>

                        
                        </a>
                    </li>

                    <?php $__currentLoopData = $orderStatuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <li class="nav-item">
                        <a href="<?php echo e(route('admin.order.index', str_replace(' ', '_', $status->value))); ?>"
                            class="nav-link <?php echo e(request()->url() === route('admin.order.index', str_replace(' ', '_', $status->value)) ? 'active' : ''); ?>">
                            <span><?php echo e(__($status->value)); ?></span>
                        </a>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </ul>
            <div class="table-responsive">

                <table class="table border-left-right table-responsive-lg">
                    <thead>
                        <tr>
                            <th style="min-width: 85px"><?php echo e(__('Order ID')); ?></th>
                            <th><?php echo e(__('Order Date')); ?></th>
                            <th><?php echo e(__('Customer')); ?></th>
                            <?php if($businessModel == 'multi'): ?>
                                <th><?php echo e(__('Shop')); ?></th>
                            <?php endif; ?>
                            <th><?php echo e(__('Total Amount')); ?></th>
                            <th><?php echo e(__('Payment Method')); ?></th>
                            <th><?php echo e(__('Action')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td class="w-auto"><?php echo e($order->prefix . $order->order_code); ?></td>
                                <td class="w-min"><?php echo e($order->created_at->format('d M Y, h:i A')); ?></td>
                                <td class="w-min"><?php echo e($order->customer?->user?->name); ?></td>

                                <?php if($businessModel == 'multi'): ?>
                                    <td class="w-min">
                                        <?php echo e($order->shop?->name); ?>

                                    </td>
                                <?php endif; ?>
                                <td class="w-min">
                                    <?php echo e(showCurrency($order->payable_amount)); ?>

                                    <br>
                                    <span class="badge rounded-pill text-bg-primary"><?php echo e($order->payment_status); ?></span>
                                </td>
                                <td class="w-min"><?php echo e($order->payment_method); ?></td>
                                <td class="w-min">
                                    <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.order.show')): ?>
                                        <a href="<?php echo e(route('admin.order.show', $order->id)); ?>" data-bs-toggle="tooltip"
                                            data-bs-placement="top" data-bs-title="<?php echo e(__('view details')); ?>"
                                            class="circleIcon svg-bg">
                                            <img src="<?php echo e(asset('assets/icons-admin/eye.svg')); ?>" alt="icon"
                                                loading="lazy" />
                                        </a>
                                    <?php endif; ?>
                                    <a href="<?php echo e(route('shop.download-invoice', $order->id)); ?>" data-bs-toggle="tooltip"
                                        data-bs-placement="left" data-bs-title="<?php echo e(__('Download Invoice')); ?>"
                                        class="circleIcon btn-outline-secondary">
                                        <img src="<?php echo e(asset('assets/icons-admin/download-alt.svg')); ?>" alt="icon"
                                            loading="lazy" />
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="100%" class="text-center">
                                    <?php echo e(__('No order found')); ?>

                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>

            </div>

        </div>
    </div>

    <div class="my-3">
        <?php echo e($orders->links()); ?>

    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home4/righthir/righthire.co.in/resources/views/admin/order/index.blade.php ENDPATH**/ ?>