<?php $__env->startSection('header-title', __('Rider Details')); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex align-items-center flex-wrap gap-3 justify-content-between px-3">
        <h4>
            <?php echo e(__('Rider Details')); ?>

        </h4>
    </div>

    <div class="container-fluid mt-3">

        <div class="row">
            <div class="col-md-6 col-lg-4 col-xl-3 mb-3">
                <div class="dashboard-summery bg-alternate">
                    <h2><?php echo e($totalPending); ?></h2>
                    <h3>
                        <?php echo e(__('ToDo Orders')); ?>

                    </h3>
                    <div class="icon">
                        <i class="bi bi-bicycle"></i>
                    </div>
                </div>
            </div>

            <div class="col-md-6 col-lg-4 col-xl-3 mb-3">
                <div class="dashboard-summery bg-midnight-bloom">
                    <h2><?php echo e($totalDelivery); ?></h2>
                    <h3>
                        <?php echo e(__('Total Delivered')); ?>

                    </h3>
                    <div class="icon">
                        <i class="bi bi-truck"></i>
                    </div>
                </div>
            </div>

            <div class="col-md-6 col-lg-4 col-xl-3 mb-3">
                <div class="dashboard-summery bg-grow-early">
                    <h2><?php echo e(showCurrency($driver->total_cash_collected)); ?></h2>
                    <h3>
                        <?php echo e(__('Current Cash Collected')); ?>

                    </h3>
                    <div class="icon">
                        <i class="bi bi-cash-coin"></i>
                    </div>
                </div>
            </div>

            <div class="col-md-6 col-lg-4 col-xl-3 mb-3">
                <div class="dashboard-summery bg-arielle-smile">
                    <h2><?php echo e(showCurrency($allCashCollected)); ?></h2>
                    <h3>
                        <?php echo e(__('Total Cash Collected')); ?>

                    </h3>
                    <div class="icon">
                        <i class="bi bi-cash-coin"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="card my-3">
            <div class="card-body">
                <div class="cardTitleBox">
                    <h5 class="card-title chartTitle">
                        <i class="bi bi-wallet2"></i> <?php echo e(__('Rider Wallet')); ?>

                    </h5>
                </div>

                <div class="row">
                    <div class="col-md-5">
                        <div class="wallet py-4 px-3">
                            <div class="wallet-icon">
                                <img src="<?php echo e(asset('assets/images/wallet.png')); ?>" alt="" width="100%">
                            </div>
                            <h3 class="balance"><?php echo e(showCurrency($wallet->balance)); ?></h3>

                            <div class="title">
                                <?php echo e(__('Current Balance')); ?>

                            </div>
                        </div>
                    </div>

                    <div class="col-md-7">
                        <div class="row gy-4">

                            <div class="col-md-6">
                                <div class="wallet-others py-md-4">
                                    <div>
                                        <div class="amount"><?php echo e(showCurrency($alreadyWithdraw)); ?></div>
                                        <div class="title">
                                            <?php echo e(__('Already Withdraw')); ?>

                                        </div>
                                    </div>
                                    <div class="icon">
                                        <img src="<?php echo e(asset('assets/icons/alreadyWithdraw.png')); ?>" alt="icon" />
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="wallet-others py-md-4">
                                    <div>
                                        <div class="amount"><?php echo e(showCurrency($pendingWithdraw)); ?></div>
                                        <div class="title">
                                            <?php echo e(__('Pending Withdraw')); ?>

                                        </div>
                                    </div>
                                    <div class="icon">
                                        <img src="<?php echo e(asset('assets/icons/pendingWithdraw.png')); ?>" alt="icon" />
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="wallet-others py-md-4">
                                    <div>
                                        <div class="amount"><?php echo e(showCurrency($driver->total_cash_collected)); ?></div>
                                        <div class="title">
                                            <?php echo e(__('Current Cash Collected')); ?>

                                        </div>
                                    </div>
                                    <div class="icon">
                                        <img src="<?php echo e(asset('assets/icons/totalEarn.png')); ?>" alt="icon" />
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="wallet-others py-md-4">
                                    <div>
                                        <div class="amount"><?php echo e(showCurrency($deniedWithdraw)); ?></div>
                                        <div class="title">
                                        <?php echo e(__('Rejected Withdraw')); ?>

                                        </div>
                                    </div>
                                    <div class="icon">
                                        <img src="<?php echo e(asset('assets/icons/reject.png')); ?>" alt="icon" />
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <div class="cardTitleBox">
                    <h5 class="card-title chartTitle">
                       <?php echo e(__('All Assigned Orders')); ?>

                    </h5>
                </div>
                <div class="table-responsive">

                    <table class="table border-left-right table-responsive-lg">
                        <thead>
                            <tr>
                                <th style="min-width: 85px"><?php echo e(__('Order ID')); ?></th>
                                <th><?php echo e(__('Assigned At')); ?></th>
                                <th><?php echo e(__('Customer')); ?></th>
                                <th><?php echo e(__('Shop')); ?></th>
                                <th><?php echo e(__('Total Amount')); ?></th>
                                <th><?php echo e(__('Payment Method')); ?></th>
                                <th><?php echo e(__('Order Status')); ?></th>
                                <th style="width: 80px"><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $orders = $driver->orders()->orderBy('pivot_created_at', 'desc')->orderBy('pivot_is_completed', 'asc')->paginate(20);
                            ?>
                            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="w-auto">
                                        #<?php echo e($order->prefix . $order->order_code); ?>

                                    </td>
                                    <td class="w-min">
                                        <?php echo e($order->pivot->created_at->format('d M Y, h:i A')); ?>

                                    </td>
                                    <td class="w-min">
                                        <?php echo e($order->customer?->user?->name); ?>

                                    </td>

                                    <td class="w-min">
                                        <?php echo e($order->shop?->name); ?>

                                    </td>
                                    <td class="w-min">
                                        <?php echo e(showCurrency($order->payable_amount)); ?>

                                        <br>
                                        <span class="badge rounded-pill text-bg-primary"><?php echo e($order->payment_status); ?></span>
                                    </td>
                                    <td class="w-min"><?php echo e($order->payment_method); ?></td>

                                    <td class="tableStatus">
                                        <?php
                                            $status = Str::ucfirst(str_replace(' ', '', $order->order_status->value));
                                        ?>
                                        <div class="statusItem">
                                            <div class="circleDot animated<?php echo e($status); ?>"></div>
                                            <div class="statusText">
                                                <span class="status<?php echo e($status); ?>">
                                                    <?php echo e($order->order_status->value); ?>

                                                </span>
                                            </div>
                                        </div>
                                    </td>

                                    <td>
                                        <a href="<?php echo e(route('admin.order.show', $order->id)); ?>" data-bs-toggle="tooltip"
                                            data-bs-placement="top" data-bs-title="<?php echo e(__('view details')); ?>"
                                            class="circleIcon btn-outline-primary">
                                            <i class="bi bi-eye-fill"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                    <?php echo e($orders->links()); ?>


                </div>
            </div>
        </div>

    </div>

    <!-- Withdraw Modal -->
    <form action="<?php echo e(route('admin.withdraw.update', $user->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="modal fade" id="withdrawModal" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5">
                            <?php echo e(__('Withdraw Update')); ?>

                        </h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div>
                            <?php if (isset($component)) { $__componentOriginalbf566fc26595b9cc6779e170beef8a5a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbf566fc26595b9cc6779e170beef8a5a = $attributes; } ?>
<?php $component = App\View\Components\Select::resolve(['name' => 'status','label' => 'Withdraw Status','required' => 'true'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('select'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Select::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                                <option value="approved"><?php echo e(__('Approved')); ?></option>
                                <option value="denied"><?php echo e(__('Denied')); ?></option>
                             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbf566fc26595b9cc6779e170beef8a5a)): ?>
<?php $attributes = $__attributesOriginalbf566fc26595b9cc6779e170beef8a5a; ?>
<?php unset($__attributesOriginalbf566fc26595b9cc6779e170beef8a5a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbf566fc26595b9cc6779e170beef8a5a)): ?>
<?php $component = $__componentOriginalbf566fc26595b9cc6779e170beef8a5a; ?>
<?php unset($__componentOriginalbf566fc26595b9cc6779e170beef8a5a); ?>
<?php endif; ?>
                        </div>

                        <div class="mt-3">
                            <label class="form-label"><?php echo e(__('Any Reason')); ?></label>
                            <textarea name="reason" placeholder="<?php echo e(__('Enter Any Reason')); ?>" class="form-control"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('Update')); ?></button>
                    </div>
                </div>
            </div>
        </div>
    </form>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home4/righthir/righthire.co.in/resources/views/admin/rider/show.blade.php ENDPATH**/ ?>