<?php $__env->startSection('header-title', __('Verification OTP Settings')); ?>

<?php $__env->startSection('content'); ?>
    <div class="page-title">
        <div class="d-flex gap-2 align-items-center">
            <i class="fa-solid fa-unlock"></i> <?php echo e(__('Verification OTP Settings')); ?>

        </div>
    </div>

    <div class="row">
        <div class="col-xl-9">
            <form action="<?php echo e(route('admin.verification.update')); ?>" method="POST">
                <?php echo csrf_field(); ?>

                <!--######## Basic Information ##########-->
                <div class="card mt-4">
                    <div class="card-body">

                        <div class="border mt-3 rounded-3">

                            <div class="d-flex align-items-center gap-2 border-bottom p-2">
                                <i class="bi bi-briefcase-fill"></i>
                                <h5 class="mb-0"><?php echo e(__('Verification')); ?></h5>
                            </div>

                            <div class="p-3">
                                <div class="row gy-3">
                                    <div class="col-lg-6">
                                        <div class="border rounded p-2 d-flex align-items-center justify-content-between gap-2 flex-wrap flex-grow-1">
                                            <label class="form-label m-0 fw-medium" for="otpVerify">
                                                <?php echo e(__('Customer Registration OTP Verify')); ?>

                                            </label>
                                            <label class="switch mb-0">
                                                <input id="otpVerify" type="checkbox"
                                                    <?php echo e($verifyManage?->register_otp ? 'checked' : ''); ?> name="register_otp">
                                                <span class="slider round"></span>
                                            </label>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="border rounded p-2 d-flex align-items-center justify-content-between gap-2 flex-wrap flex-grow-1">
                                            <label class="form-label m-0 fw-medium" for="verifyAccount">
                                                <?php echo e(__('Must Verify Account on Order Placement')); ?>

                                            </label>
                                            <label class="switch mb-0">
                                                <input id="verifyAccount" type="checkbox"
                                                    <?php echo e($verifyManage?->order_place_account_verify ? 'checked' : ''); ?> name="order_place_account_verify">
                                                <span class="slider round"></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="row gy-3 mt-3">
                                    <div class="col-lg-6">
                                        <label class="form-label fw-medium">
                                            <?php echo e(__('Register OTP Send / Account Verify Method')); ?>

                                        </label>
                                        <div class="d-flex flex-wrap align-items-center gap-5 border rounded fw-medium"
                                            style="padding: 10px;">
                                            <div class="flex-grow-1 d-flex align-items-center gap-1">
                                                <input type="radio" name="register_otp_type" value="phone"
                                                    class="form-check-input m-0" id="single"
                                                    <?php echo e($verifyManage?->register_otp_type == 'phone' ? 'checked' : ''); ?>>
                                                <label for="single" class="m-0 cursor-pointer">
                                                    <?php echo e(__('Phone')); ?>

                                                </label>
                                            </div>

                                            <div class="flex-grow-1 d-flex align-items-center gap-1">
                                                <input type="radio" name="register_otp_type" value="email"
                                                    class="form-check-input m-0" id="emailRegisterOTP"
                                                    <?php echo e($verifyManage?->register_otp_type == 'email' ? 'checked' : ''); ?>>
                                                <label for="emailRegisterOTP" class="m-0 cursor-pointer">
                                                    <?php echo e(__('Email')); ?>

                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <label class="form-label fw-medium">
                                            <?php echo e(__('Forget Password OTP Send Method')); ?>

                                        </label>
                                        <div class="d-flex flex-wrap align-items-center gap-5 border rounded fw-medium"
                                            style="padding: 10px;">
                                            <div class="flex-grow-1 d-flex align-items-center gap-1">
                                                <input type="radio" name="forgot_otp_type" value="phone"
                                                    class="form-check-input m-0" id="forgetOTPPhone"
                                                    <?php echo e($verifyManage?->forgot_otp_type == 'phone' ? 'checked' : ''); ?>>
                                                <label for="forgetOTPPhone" class="m-0 cursor-pointer">
                                                    <?php echo e(__('Phone')); ?>

                                                </label>
                                            </div>

                                            <div class="flex-grow-1 d-flex align-items-center gap-1">
                                                <input type="radio" name="forgot_otp_type" value="email"
                                                    class="form-check-input m-0" id="forgetOTPEmail"
                                                    <?php echo e($verifyManage?->forgot_otp_type == 'email' ? 'checked' : ''); ?>>
                                                <label for="forgetOTPEmail" class="m-0 cursor-pointer">
                                                    <?php echo e(__('Email')); ?>

                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="border mt-4 rounded-3">
                            <div class="border-bottom p-2 fw-bold fz-16">
                                <?php echo e(__('Phone Number Validation')); ?>

                            </div>

                            <div class="p-3">

                                <div class="border rounded p-2 d-flex align-items-center justify-content-between gap-2 flex-wrap"
                                    style="max-width: 400px">
                                    <label class="form-label m-0 fw-medium" for="toggle">
                                        <?php echo e(__('Registration Phone Required')); ?>

                                    </label>
                                    <label class="switch mb-0" data-bs-toggle="tooltip" data-bs-placement="left"
                                        data-bs-title="Optional/Required">
                                        <input id="toggle" type="checkbox"
                                            <?php echo e($verifyManage?->phone_required ? 'checked' : ''); ?> name="phone_required">
                                        <span class="slider round"></span>
                                    </label>
                                </div>

                                <div class="row gy-3 mt-3">
                                    <div class="col-md-6">
                                        <?php if (isset($component)) { $__componentOriginal786b6632e4e03cdf0a10e8880993f28a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal786b6632e4e03cdf0a10e8880993f28a = $attributes; } ?>
<?php $component = App\View\Components\Input::resolve(['type' => 'text','name' => 'phone_min_length','label' => 'Minimum Length (without Country Code)','value' => $verifyManage?->phone_min_length ?? 9,'onlyNumber' => 'true'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Input::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal786b6632e4e03cdf0a10e8880993f28a)): ?>
<?php $attributes = $__attributesOriginal786b6632e4e03cdf0a10e8880993f28a; ?>
<?php unset($__attributesOriginal786b6632e4e03cdf0a10e8880993f28a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal786b6632e4e03cdf0a10e8880993f28a)): ?>
<?php $component = $__componentOriginal786b6632e4e03cdf0a10e8880993f28a; ?>
<?php unset($__componentOriginal786b6632e4e03cdf0a10e8880993f28a); ?>
<?php endif; ?>
                                    </div>

                                    <div class="col-md-6">
                                        <?php if (isset($component)) { $__componentOriginal786b6632e4e03cdf0a10e8880993f28a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal786b6632e4e03cdf0a10e8880993f28a = $attributes; } ?>
<?php $component = App\View\Components\Input::resolve(['type' => 'text','name' => 'phone_max_length','label' => 'Maximum Length (without Country Code)','value' => $verifyManage?->phone_max_length ?? 14,'onlyNumber' => 'true'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Input::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal786b6632e4e03cdf0a10e8880993f28a)): ?>
<?php $attributes = $__attributesOriginal786b6632e4e03cdf0a10e8880993f28a; ?>
<?php unset($__attributesOriginal786b6632e4e03cdf0a10e8880993f28a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal786b6632e4e03cdf0a10e8880993f28a)): ?>
<?php $component = $__componentOriginal786b6632e4e03cdf0a10e8880993f28a; ?>
<?php unset($__componentOriginal786b6632e4e03cdf0a10e8880993f28a); ?>
<?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.verification.update')): ?>
                            <div class="d-flex justify-content-end mt-4">
                                <button type="submit" class="btn btn-primary py-2.5 px-3">
                                    <?php echo e(__('Save And Update')); ?>

                                </button>
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home4/righthir/righthire.co.in/resources/views/admin/verification/index.blade.php ENDPATH**/ ?>