<?php $__env->startSection('title', __('Admin Settings')); ?>

<?php $__env->startSection('content'); ?>
    <div class="page-title">
        <div class="d-flex gap-2 align-items-center">
            <i class="bi bi-gear-fill"></i> <?php echo e(__('Ai Prompt')); ?>

        </div>
    </div>

    <div class="row mb-5">
        <div class="col-md-6 col-12">
            <div class="card mt-3 cardBox">

                <div class="card-header d-flex align-items-center gap-2 py-3">
                    <i class="bi bi-journal-check"></i>
                    <h5 class="mb-0"><?php echo e(__('Product Description Note')); ?></h5>
                </div>

                <form action="<?php echo e(route('admin.aiPrompt.update')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="card-body">

                        <div>
                            <strong>Note: </strong>Use <strong style="color: var(--theme-color) !important">
                                <i>{product_name}</i></strong> to insert the product’s name, and <strong
                                style="color: var(--theme-color) !important"><i>{short_description}</i></strong> to insert
                            the product’s short description in the prompt.

                        </div>
                        <label for="" class="mb-1 mt-3">
                            <?php echo e(__('Product Description')); ?> <span class="text-danger">*</span>
                        </label>
                        <textarea name="product_description" id="product_description" class="form-control" rows="4" required
                            placeholder="Enter Product Description"><?php echo e($generaleSetting?->product_description); ?></textarea>

                        <?php $__errorArgs = ['product_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text text-danger m-0"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                        <input name="page_description" type="hidden" value="<?php echo e($generaleSetting?->page_description); ?>">
                        <input name="blog_description" type="hidden" value="<?php echo e($generaleSetting?->blog_description); ?>">

                    </div>
                    <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.aiPrompt.update')): ?>
                        <div class="d-flex justify-content-end mt-4 mb-3 me-3">
                            <button type="submit" id="saveBtn1" class="btn btn-primary py-2.5 px-3">
                                <?php echo e(__('Save And Update')); ?>

                            </button>
                        </div>
                    <?php endif; ?>

                </form>
            </div>
        </div>
        <div class="col-md-6 col-12">
            <div class="card mt-3 cardBox">
                <div class="card-header d-flex align-items-center gap-2 py-3">
                    <i class="bi bi-journal-check"></i>
                    <h5 class="mb-0"><?php echo e(__('Page Description Note')); ?></h5>
                </div>
                <form action="<?php echo e(route('admin.aiPrompt.update')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="card-body">

                        <div class="mb-3">
                            <strong>Note: </strong>If you use <strong style="color: var(--theme-color) !important">
                                <i>{title}</i></strong>, the page title will be automatically retrieved and inserted into
                            the main prompt.
                        </div>

                        <input name="product_description" type="hidden"
                            value="<?php echo e($generaleSetting?->product_description); ?>">
                        <input name="blog_description" type="hidden" value="<?php echo e($generaleSetting?->blog_description); ?>">
                        <label for="" class="mb-1">
                            <?php echo e(__('Page  Description')); ?> <span class="text-danger">*</span>
                        </label>
                        <textarea name="page_description" id="page_description" class="form-control" rows="4" required
                            placeholder="Enter Page Description"><?php echo e($generaleSetting?->page_description); ?></textarea>
                        <?php $__errorArgs = ['page_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text text-danger m-0"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                    </div>
                    <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.aiPrompt.update')): ?>
                        <div class="d-flex justify-content-end mt-4 mb-3 me-3">
                            <button type="submit" id="saveBtn2" class="btn btn-primary py-2.5 px-3">
                                <?php echo e(__('Save And Update')); ?>

                            </button>
                        </div>
                    <?php endif; ?>

                </form>
            </div>
        </div>
        <div class="col-md-6 col-12 ">
            <div class="card mt-3 cardBox">
                <div class="card-header d-flex align-items-center gap-2 py-3">
                    <i class="bi bi-journal-check"></i>
                    <h5 class="mb-0"><?php echo e(__('Blog Description Note')); ?></h5>
                </div>
                <form action="<?php echo e(route('admin.aiPrompt.update')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="card-body">

                        <div class="mb-3">
                            <strong>Note: </strong>If you use <strong style="color: var(--theme-color) !important">
                                <i>{title}</i></strong>, the blog title will be automatically retrieved and inserted into
                            the main prompt.
                        </div>

                        <input name="product_description" type="hidden"
                            value="<?php echo e($generaleSetting?->product_description); ?>">
                        <input name="page_description" type="hidden" value="<?php echo e($generaleSetting?->page_description); ?>">
                        <label for="" class="mb-1">
                            <?php echo e(__('Blog  Description')); ?> <span class="text-danger">*</span>
                        </label>
                        <textarea name="blog_description" id="blog_description" class="form-control" rows="4" required
                            placeholder="Enter Page Description"><?php echo e($generaleSetting?->blog_description); ?></textarea>

                        <?php $__errorArgs = ['blog_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text text-danger m-0"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                    </div>
                    <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.aiPrompt.update')): ?>
                        <div class="d-flex justify-content-end mt-4 mb-3 me-3">
                            <button type="submit" id="saveBtn3" class="btn btn-primary py-2.5 px-3">
                                <?php echo e(__('Save And Update')); ?>

                            </button>
                        </div>
                    <?php endif; ?>

                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('css'); ?>
    <style>
        .cardBox {
            box-shadow: 0 1px 11px rgba(0, 0, 0, 0.15) !important;
        }
        .btn-primary:disabled {
            background-color: #484848 !important;
            border-color: #484848!important;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const productDesc = document.getElementById("product_description");
            const pageDesc = document.getElementById("page_description");
            const blogDesc = document.getElementById("blog_description");
            const saveBtn1 = document.getElementById("saveBtn1");
            const saveBtn2 = document.getElementById("saveBtn2");
            const saveBtn3 = document.getElementById("saveBtn3");

            function validateProductDesc() {
                const value = productDesc.value;
                const hasProductName = value.includes("{product_name}");
                const hasShortDesc = value.includes("{short_description}");
                saveBtn1.disabled = !(hasProductName && hasShortDesc);
            }

            function validatePageDesc() {
                const value = pageDesc.value;
                const hasTitle = value.includes("{title}");
                saveBtn2.disabled = !hasTitle;
            }

            function validateblogDesc() {
                const value = blogDesc.value;
                const hasTitle = value.includes("{title}");
                saveBtn3.disabled = !hasTitle;
            }

            validateProductDesc();
            validatePageDesc();
            validateblogDesc();

            productDesc.addEventListener("input", validateProductDesc);
            pageDesc.addEventListener("input", validatePageDesc);
            blogDesc.addEventListener("input", validateblogDesc);
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home4/righthir/righthire.co.in/resources/views/admin/aiPrompt/index.blade.php ENDPATH**/ ?>