<?php $__env->startSection('header-title', __('Business Settings')); ?>
<?php $__env->startSection('header-subtitle', __('Manage Business Settings')); ?>

<?php $__env->startSection('content'); ?>
    <div class="page-title">
        <div class="d-flex gap-2 align-items-center">
            <i class="bi bi-buildings"></i> <?php echo e(__('Business Settings')); ?>

        </div>
    </div>

    <div class="mt-3">
        <?php echo $__env->make('admin.business-setup.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>

    <form action="<?php echo e(route('admin.business-setting.update')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>

        <!--######## Basic Information ##########-->
        <div class="card mt-4">
            <div class="card-header d-flex align-items-center gap-2 py-3">
                <i class="bi bi-briefcase-fill"></i>
                <h5 class="mb-0"><?php echo e(__('Business Information')); ?></h5>
            </div>
            <div class="card-body">
                <div class="row">

                    <div class="col-lg-4 mt-4">
                        <?php if (isset($component)) { $__componentOriginal786b6632e4e03cdf0a10e8880993f28a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal786b6632e4e03cdf0a10e8880993f28a = $attributes; } ?>
<?php $component = App\View\Components\Input::resolve(['type' => 'text','label' => 'Company Name','name' => 'name','placeholder' => 'Enter Company Name / Business Name','value' => $generaleSetting?->name] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Input::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal786b6632e4e03cdf0a10e8880993f28a)): ?>
<?php $attributes = $__attributesOriginal786b6632e4e03cdf0a10e8880993f28a; ?>
<?php unset($__attributesOriginal786b6632e4e03cdf0a10e8880993f28a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal786b6632e4e03cdf0a10e8880993f28a)): ?>
<?php $component = $__componentOriginal786b6632e4e03cdf0a10e8880993f28a; ?>
<?php unset($__componentOriginal786b6632e4e03cdf0a10e8880993f28a); ?>
<?php endif; ?>
                    </div>

                    <div class="col-lg-4 mt-4">
                        <?php if (isset($component)) { $__componentOriginal786b6632e4e03cdf0a10e8880993f28a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal786b6632e4e03cdf0a10e8880993f28a = $attributes; } ?>
<?php $component = App\View\Components\Input::resolve(['type' => 'text','label' => 'Company Email','name' => 'email','placeholder' => 'Enter Company Email','value' => $generaleSetting?->email] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Input::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal786b6632e4e03cdf0a10e8880993f28a)): ?>
<?php $attributes = $__attributesOriginal786b6632e4e03cdf0a10e8880993f28a; ?>
<?php unset($__attributesOriginal786b6632e4e03cdf0a10e8880993f28a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal786b6632e4e03cdf0a10e8880993f28a)): ?>
<?php $component = $__componentOriginal786b6632e4e03cdf0a10e8880993f28a; ?>
<?php unset($__componentOriginal786b6632e4e03cdf0a10e8880993f28a); ?>
<?php endif; ?>
                    </div>

                    <div class="col-lg-4 mt-4">
                        <?php if (isset($component)) { $__componentOriginal786b6632e4e03cdf0a10e8880993f28a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal786b6632e4e03cdf0a10e8880993f28a = $attributes; } ?>
<?php $component = App\View\Components\Input::resolve(['type' => 'text','label' => 'Company Phone','name' => 'mobile','placeholder' => 'Enter Company Phone','value' => $generaleSetting?->mobile] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Input::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal786b6632e4e03cdf0a10e8880993f28a)): ?>
<?php $attributes = $__attributesOriginal786b6632e4e03cdf0a10e8880993f28a; ?>
<?php unset($__attributesOriginal786b6632e4e03cdf0a10e8880993f28a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal786b6632e4e03cdf0a10e8880993f28a)): ?>
<?php $component = $__componentOriginal786b6632e4e03cdf0a10e8880993f28a; ?>
<?php unset($__componentOriginal786b6632e4e03cdf0a10e8880993f28a); ?>
<?php endif; ?>
                    </div>

                    <?php
                        $businessType = $generaleSetting?->shop_type ?? 'multi';
                    ?>

                    <div class="col-lg-4 mt-4">
                        <label class="form-label"><?php echo e(__('Business Model')); ?></label>
                        <div class="d-flex flex-wrap align-items-center gap-5 border rounded fw-medium"
                            style="padding: 10px;">
                            <div class="flex-grow-1">
                                <input type="radio" name="shop_type" value="single" class="form-check-input"
                                    id="single" <?php echo e($businessType == 'single' ? 'checked' : ''); ?>>
                                <label for="single" class="m-0 cursor-pointer">
                                    <?php echo e(__('Single Shop')); ?>

                                </label>
                            </div>

                            <div class="flex-grow-1 d-flex align-items-center gap-2">
                                <input type="radio" name="shop_type" value="multi" class="form-check-input"
                                    id="multi" <?php echo e($businessType == 'multi' ? 'checked' : ''); ?>>
                                <label for="multi" class="m-0 cursor-pointer">
                                    <?php echo e(__('Multi Shop')); ?>

                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 mt-4">
                        <label class="form-label">
                            <?php echo e(__('Currency Position')); ?>

                        </label>
                        <div class="d-flex flex-wrap align-items-center gap-5 border rounded fw-medium"
                            style="padding: 10px;">
                            <div class="flex-grow-1">
                                <input type="radio" name="currency_position" value="prefix" class="form-check-input"
                                    id="prefix" <?php echo e($generaleSetting?->currency_position == 'prefix' ? 'checked' : ''); ?>>
                                <label for="prefix" class="m-0">
                                    (<?php echo e($generaleSetting?->currency ?? '$'); ?>) <?php echo e(__('Left')); ?>

                                </label>
                            </div>

                            <div class="flex-grow-1 d-flex align-items-center gap-2">
                                <input type="radio" name="currency_position" value="suffix" class="form-check-input"
                                    id="suffix" <?php echo e($generaleSetting?->currency_position == 'suffix' ? 'checked' : ''); ?>>
                                <label for="suffix" class="m-0">
                                    <?php echo e(__('Right')); ?> (<?php echo e($generaleSetting?->currency ?? '$'); ?>)
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 mt-4">
                        <?php if (isset($component)) { $__componentOriginalbf566fc26595b9cc6779e170beef8a5a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbf566fc26595b9cc6779e170beef8a5a = $attributes; } ?>
<?php $component = App\View\Components\Select::resolve(['name' => 'timezone','label' => 'Time Zone'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('select'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Select::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                            <?php $__currentLoopData = $timezones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timezone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($timezone['zone']); ?>"
                                    <?php echo e(config('app.timezone') == $timezone['zone'] ? 'selected' : ''); ?>>
                                    <?php echo e($timezone['diff_from_GMT'] . ' - ' . $timezone['zone']); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbf566fc26595b9cc6779e170beef8a5a)): ?>
<?php $attributes = $__attributesOriginalbf566fc26595b9cc6779e170beef8a5a; ?>
<?php unset($__attributesOriginalbf566fc26595b9cc6779e170beef8a5a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbf566fc26595b9cc6779e170beef8a5a)): ?>
<?php $component = $__componentOriginalbf566fc26595b9cc6779e170beef8a5a; ?>
<?php unset($__componentOriginalbf566fc26595b9cc6779e170beef8a5a); ?>
<?php endif; ?>
                    </div>

                    <div class="col-lg-4 mt-4">
                        <?php if (isset($component)) { $__componentOriginal786b6632e4e03cdf0a10e8880993f28a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal786b6632e4e03cdf0a10e8880993f28a = $attributes; } ?>
<?php $component = App\View\Components\Input::resolve(['type' => 'number','label' => 'Return Order Within Days','name' => 'return_order_within_days','value' => $generaleSetting?->return_order_within_days] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Input::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['min' => '1']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal786b6632e4e03cdf0a10e8880993f28a)): ?>
<?php $attributes = $__attributesOriginal786b6632e4e03cdf0a10e8880993f28a; ?>
<?php unset($__attributesOriginal786b6632e4e03cdf0a10e8880993f28a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal786b6632e4e03cdf0a10e8880993f28a)): ?>
<?php $component = $__componentOriginal786b6632e4e03cdf0a10e8880993f28a; ?>
<?php unset($__componentOriginal786b6632e4e03cdf0a10e8880993f28a); ?>
<?php endif; ?>
                    </div>

                </div>

            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header py-3">
                <h4 class="card-title m-0 fz-20">
                    <i class="bi bi-credit-card-2-front-fill"></i> <?php echo e(__('Payment Method Setup')); ?>

                </h4>
            </div>
            <div class="card-body">
                <div class="d-flex flex-wrap gap-3">
                    <!-- Cash on Delivery -->
                    <label for="cash"
                        class="payment-card border p-3 rounded <?php echo e($generaleSetting?->cash_on_delivery ? 'selected' : ''); ?>">
                        <div class="d-flex align-items-center">
                            <div class="me-3 fs-3">💰</div>
                            <span class="fw-semibold">
                                <?php echo e(__('Cash on Delivery')); ?>

                            </span>
                        </div>
                        <div class="mt-2 d-flex align-items-center gap-1">
                            <span class="fw-semibold text-muted">
                                <?php echo e($generaleSetting?->cash_on_delivery ? __('Enable') : __('Disable')); ?>

                            </span>
                            <label class="switch mb-0">
                                <input id="cash" name="cash_on_delivery" type="checkbox"
                                    <?php echo e($generaleSetting?->cash_on_delivery ? 'checked' : ''); ?>>
                                <span class="slider round"></span>
                            </label>
                        </div>
                        <div class="check-icon">✅</div>
                    </label>

                    <!-- Online Payment -->
                    <label for="online"
                        class="payment-card border p-3 rounded <?php echo e($generaleSetting?->online_payment ? 'selected' : ''); ?>">
                        <div class="d-flex align-items-center">
                            <div class="me-3 fs-3">💳</div>
                            <span class="fw-semibold">
                                <?php echo e(__('Online Payment')); ?>

                            </span>
                        </div>
                        <div class="mt-2 d-flex align-items-center gap-1">
                            <span class="fw-semibold text-muted">
                                <?php echo e($generaleSetting?->online_payment ? __('Enable') : __('Disable')); ?>

                            </span>
                            <label class="switch mb-0">
                                <input id="online" name="online_payment" type="checkbox"
                                    <?php echo e($generaleSetting?->online_payment ? 'checked' : ''); ?> />
                                <span class="slider round"></span>
                            </label>
                        </div>
                        <div class="check-icon">✅</div>
                    </label>
                </div>

            </div>
        </div>

        <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.business-setting.update')): ?>
            <div class="d-flex justify-content-end mt-4 mb-3">
                <button type="submit" class="btn btn-primary py-2.5 px-3">
                    <?php echo e(__('Save And Update')); ?>

                </button>
            </div>
        <?php endif; ?>
    </form>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('css'); ?>
    <style>
        .payment-card {
            transition: all 0.3s ease-in-out;
            cursor: pointer;
            position: relative;
            min-width: 280px;
        }

        .payment-card.selected {
            border-color: #28a745 !important;
            box-shadow: 0 0 4px rgba(40, 167, 69, 0.3);
        }

        .check-icon {
            position: absolute;
            top: 6px;
            right: 10px;
            font-size: 1rem;
            color: #28a745;
            display: none;
        }

        .payment-card.selected .check-icon {
            display: block;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        $('#cash, #online').on('change', function() {
            if ($(this).is(':checked')) {
                $(this).closest('.payment-card').addClass('selected');
            } else {
                $(this).closest('.payment-card').removeClass('selected');
                if (!$('#cash').is(':checked') && !$('#online').is(':checked')) {
                    $('#cash').closest('.payment-card').addClass('selected');
                    $('#cash').prop('checked', true);
                }
            }
        });

        $('#online').on('change', function() {
            if (!$(this).is(':checked')) {
                $('#cash').prop('checked', true);
                $('#cash').closest('.payment-card').addClass('selected');
            }
        });

        $('#commission').on('change', function() {
            if ($(this).is(':checked')) {
                $(this).closest('.payment-card').addClass('selected');
                $('#subscription').closest('.payment-card').removeClass('selected');
            } else {
                $(this).closest('.payment-card').removeClass('selected');
                $('#subscription').closest('.payment-card').addClass('selected');
            }
        });

        $('#subscription').on('change', function() {
            if ($(this).is(':checked')) {
                $(this).closest('.payment-card').addClass('selected');
                $('#commission').closest('.payment-card').removeClass('selected');
            } else {
                $(this).closest('.payment-card').removeClass('selected');
                $('#commission').closest('.payment-card').addClass('selected');
            }
        });

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home4/righthir/righthire.co.in/resources/views/admin/business-setup/index.blade.php ENDPATH**/ ?>