<div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 row-cols-xxl-4 g-4">
    <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="col">
            <div class="card shadow-sm d-flex flex-column h-100">
                <img src="<?php echo e($product->thumbnail); ?>" alt="" class="card-img-top" loading="lazy" width="100%"
                    style="height: 200px; object-fit: cover" />
                <div class="card-body h-100">
                    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2">
                        <label class="switch mb-0" data-bs-toggle="tooltip" data-bs-placement="left"
                            data-bs-title="<?php echo e(__('Update product status')); ?>">
                            <a href="<?php echo e(route('shop.product.toggle', $product->id)); ?>">
                                <input type="checkbox" <?php echo e($product->is_active ? 'checked' : ''); ?>>
                                <span class="slider round"></span>
                            </a>
                        </label>
                        <div class="d-flex gap-2">
                            <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'shop.product.show')): ?>
                                <a href="<?php echo e(route('shop.product.show', $product->id)); ?>"
                                    class="svg-bg btn-outline-primary circleIcon btn-sm" data-bs-toggle="tooltip"
                                    data-bs-placement="left" data-bs-title="<?php echo e(__('View Product')); ?>">
                                    <img src="<?php echo e(asset('assets/icons-admin/eye.svg')); ?>" alt="icon" loading="lazy" />
                                </a>
                            <?php endif; ?>
                            <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'shop.product.barcode')): ?>
                                <a href="<?php echo e(route('shop.product.barcode', $product->id)); ?>"
                                    class="btn-outline-info circleIcon btn-sm" data-bs-toggle="tooltip"
                                    data-bs-placement="top" data-bs-title="<?php echo e(__('Generate Barcode for this product')); ?>">
                                    <i class="bi bi-upc-scan"></i>
                                </a>
                            <?php endif; ?>
                            <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'shop.product.edit')): ?>
                                <a href="<?php echo e(route('shop.product.edit', $product->id)); ?>"
                                    class="btn-outline-info circleIcon btn-sm" data-bs-toggle="tooltip"
                                    data-bs-placement="left" data-bs-title="<?php echo e(__('Edit Product')); ?>">
                                    <img src="<?php echo e(asset('assets/icons-admin/edit.svg')); ?>" alt="icon" loading="lazy" />
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="mt-3">
                        <h5 class="card-title"><?php echo e(Str::limit($product->name, 50, '...')); ?></h5>

                        <p>
                            <?php echo e($product->short_description); ?>

                        </p>

                        <div class="d-flex justify-content-between align-items-center gap-3 flex-wrap mt-3">
                            <p class="card-text m-0 d-flex align-items-center gap-1">
                                <strong><?php echo e(showCurrency($product->price)); ?></strong>
                                <?php if($product->discount_price): ?>
                                    <span class="badge bg-primary rounded-pill">
                                        <?php echo e(showCurrency($product->discount_price)); ?>

                                    </span>
                                <?php endif; ?>
                            </p>

                            <div class="d-flex align-items-center gap-1">
                                <i class="fa fa-star text-warning"></i>
                                (<?php echo e(number_format($product->reviews->avg('rating'), 1)); ?>)
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="col">
            <div class="card shadow-sm">
                <div class="card-body text-center">
                    <?php echo e(__('No Data Found')); ?>

                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
<?php /**PATH /home4/righthir/righthire.co.in/resources/views/shop/product/gridView.blade.php ENDPATH**/ ?>