<?php $__env->startSection('header-title', __('Promo Codes')); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex align-items-center flex-wrap gap-3 justify-content-between px-3">

        <h4> <?php echo e(__('Promo Codes')); ?> </h4>

        <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.coupon.create')): ?>
        <a href="<?php echo e(route('admin.coupon.create')); ?>" class="btn py-2 btn-primary">
            <i class="bi bi-patch-plus"></i>
           <?php echo e(__('Add Promo Code')); ?>

        </a>
        <?php endif; ?>
    </div>

    <div class="mt-4">
        <div class="row">
            <div class="col-lg-12 mb-3">
                <div class="card rounded-12">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table border-left-right">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('Code')); ?></th>
                                        <th><?php echo e(__('Discount')); ?></th>
                                        <th><?php echo e(__('Min Amount')); ?></th>
                                        <th><?php echo e(__('Started At')); ?></th>
                                        <th><?php echo e(__('Expired At')); ?></th>
                                        <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.coupon.toggle')): ?>
                                        <th><?php echo e(__('Status')); ?></th>
                                        <?php endif; ?>
                                        <th><?php echo e(__('Action')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php $__currentLoopData = $coupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coupon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($coupon->code); ?></td>
                                            <td>
                                                <?php echo $coupon->type->value == 'Amount' ? showCurrency($coupon->discount) : $coupon->discount . '%'; ?>

                                            </td>
                                            <td>
                                                <?php echo e(showCurrency($coupon->min_amount)); ?>

                                            </td>
                                            <td>
                                                <?php echo e(Carbon\Carbon::parse($coupon->started_at)->format('M d, Y h:i a')); ?>

                                            </td>
                                            <td>
                                                <?php echo e(Carbon\Carbon::parse($coupon->expired_at)->format('M d, Y h:i a')); ?>

                                            </td>
                                            <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.coupon.toggle')): ?>
                                            <td>
                                                <label class="switch mb-0" data-bs-toggle="tooltip" data-bs-placement="left"
                                                    data-bs-title="<?php echo e(__('Status Update')); ?>">
                                                    <a href="<?php echo e(route('admin.coupon.toggle', $coupon->id)); ?>">
                                                        <input type="checkbox" <?php echo e($coupon->is_active ? 'checked' : ''); ?>>
                                                        <span class="slider round"></span>
                                                    </a>
                                                </label>
                                            </td>
                                            <?php endif; ?>
                                            <td>
                                                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.coupon.edit')): ?>
                                                <a href="<?php echo e(route('admin.coupon.edit', $coupon->id)); ?>"
                                                    class="btn btn-outline-info circleIcon" data-bs-toggle="tooltip"
                                                    data-bs-placement="left" data-bs-title="<?php echo e(__('Edit')); ?>">
                                                    <img src="<?php echo e(asset('assets/icons-admin/edit.svg')); ?>" alt="edit" loading="lazy" />
                                                </a>
                                                <?php endif; ?>

                                                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.coupon.destroy')): ?>
                                                <a href="<?php echo e(route('admin.coupon.destroy', $coupon->id)); ?>" class="btn btn-outline-danger circleIcon deleteConfirm"
                                                    data-bs-toggle="tooltip" data-bs-placement="left"
                                                    data-bs-title="<?php echo e(__('Delete')); ?>">
                                                    <img src="<?php echo e(asset('assets/icons-admin/trash.svg')); ?>" alt="delete" loading="lazy" />
                                                </a>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <?php echo e($coupons->links()); ?>


            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home4/righthir/righthire.co.in/resources/views/admin/coupon/index.blade.php ENDPATH**/ ?>