<?php $__env->startSection('header-title', __('All Drivers')); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex align-items-center flex-wrap gap-3 justify-content-between px-3">

        <h4>
            <?php echo e(__('All Drivers')); ?>

        </h4>
    </div>

    <div class="container-fluid mt-3">

        <div class="mb-3 card">
            <div class="card-header d-flex align-items-center justify-content-between gap-2 py-3">
                <h5 class="card-title m-0"> <?php echo e(__('Drivers')); ?></h5>

                <div class="d-flex gap-3">
                    <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.rider.create')): ?>
                    <a href="<?php echo e(route('admin.rider.create')); ?>" class="btn btn-primary py-2">
                        <i class="fa fa-plus-circle"></i> <?php echo e(__('Add Driver')); ?>

                    </a>
                    <?php endif; ?>
                    <div class="dropdown" style="width: 160px">
                        <a class="btn border py-2 text-start dropdown-toggle w-100" href="#" role="button"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            <?php echo e(__(request()->status ? ucfirst(request()->status) : 'All')); ?>

                        </a>
                        <ul class="dropdown-menu w-100">
                            <li>
                                <a class="dropdown-item" href="<?php echo e(route('admin.rider.index')); ?>">
                                    <?php echo e(__('All')); ?>

                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="<?php echo e(route('admin.rider.index', 'status=pending')); ?>">
                                    <?php echo e(__('Pending')); ?>

                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="<?php echo e(route('admin.rider.index', 'status=approved')); ?>">
                                    <?php echo e(__('Approved')); ?>

                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table border-left-right table-responsive-md">
                        <thead class="table-light">
                            <tr>
                                <th>SL.</th>
                                <th><?php echo e(__('Profile')); ?></th>
                                <th><?php echo e(__('Name')); ?></th>
                                <th><?php echo e(__('Phone')); ?></th>
                                <th><?php echo e(__('Status')); ?></th>
                                <th class="text-center"><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                        <?php $__empty_1 = true; $__currentLoopData = $riders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $serial = $riders->firstItem() + $key;
                            ?>
                            <tr>
                                <td><?php echo e($serial); ?></td>
                                <td>
                                    <img class="rounded-circle" src="<?php echo e($user->thumbnail); ?>" width="40" height="40"
                                        loading="lazy" />
                                </td>
                                <td><?php echo e($user->fullName); ?></td>

                                <td>
                                    <?php echo e($user->phone); ?>

                                </td>

                                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.rider.index')): ?>
                                <td>
                                    <label class="switch mb-0" data-bs-toggle="tooltip" data-bs-placement="left"
                                        data-bs-title="Change Active Status">
                                        <a href="<?php echo e(route('admin.rider.toggle', $user->id)); ?>" class="confirm">
                                            <input type="checkbox" <?php echo e($user->is_active ? 'checked' : ''); ?>>
                                            <span class="slider round"></span>
                                        </a>
                                    </label>
                                </td>
                                <?php endif; ?>

                                <td class="text-center">
                                    <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.rider.show')): ?>
                                    <a href="<?php echo e(route('admin.rider.show', $user->id)); ?>"
                                        class="btn btn-sm svg-bg circleIcon">
                                        <img src="<?php echo e(asset('assets/icons-admin/eye.svg')); ?>" alt="view" loading="lazy" />
                                    </a>
                                    <?php endif; ?>
                                    <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.rider.edit')): ?>
                                    <a href="<?php echo e(route('admin.rider.edit', $user->id)); ?>"
                                        class="btn btn-sm btn-outline-info circleIcon">
                                        <img src="<?php echo e(asset('assets/icons-admin/edit.svg')); ?>" alt="edit" loading="lazy" />
                                    </a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-center" colspan="100%"><?php echo e(__('No Data Found')); ?></td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="my-3">
            <?php echo e($riders->withQueryString()->links()); ?>

        </div>

    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        $(".confirm").on("click", function(e) {
            e.preventDefault();
            const url = $(this).attr("href");
            Swal.fire({
                title: "Are you sure?",
                text: "You want to change active status!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, Change it!",
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = url;
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home4/righthir/righthire.co.in/resources/views/admin/rider/index.blade.php ENDPATH**/ ?>