<?php $__env->startSection('title', __('Social Link List')); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex align-items-center flex-wrap gap-3 justify-content-between px-3">
        <h4>
            <?php echo e(__('Social link List')); ?>

        </h4>
    </div>

    <div class="container-fluid mt-3">

        <div class="mb-3 card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-responsive-md">
                        <thead>
                            <tr>
                                <th class="text-center"><?php echo e(__('SL')); ?></th>
                                <th><?php echo e(__('Name')); ?></th>
                                <th><?php echo e(__('Link')); ?></th>
                                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.socialLink.toggle')): ?>
                                    <th><?php echo e(__('Status')); ?></th>
                                <?php endif; ?>
                                <th class="text-center"><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                        <?php $__empty_1 = true; $__currentLoopData = $socialLinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $socialLink): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $serial = $socialLinks->firstItem() + $key;
                            ?>
                            <tr>
                                <td class="text-center"><?php echo e($serial); ?></td>
                                <td>
                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                        <div class="social-icon">
                                            <img src="<?php echo e(asset($socialLink->logo)); ?>" alt="" width="22">
                                        </div>
                                        <?php echo e($socialLink->name); ?>

                                    </div>
                                </td>

                                <td>
                                    <?php echo e($socialLink->link ? Str::limit($socialLink->link, 60, '...') : '--'); ?>

                                </td>

                                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.socialLink.toggle')): ?>
                                    <td>
                                        <label class="switch mb-0">
                                            <a href="<?php echo e(route('admin.socialLink.toggle', $socialLink->id)); ?>">
                                                <input type="checkbox" <?php echo e($socialLink->is_active ? 'checked' : ''); ?>>
                                                <span class="slider round"></span>
                                            </a>
                                        </label>
                                    </td>
                                <?php endif; ?>

                                <td class="text-center">
                                    <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.socialLink.update')): ?>
                                        <div class="d-flex gap-3 justify-content-center">
                                            <button type="button" class="btn btn-outline-primary circleIcon btn-sm"
                                                onclick="openColorUpdateModal(<?php echo e($socialLink); ?>)">
                                                <img src="<?php echo e(asset('assets/icons-admin/edit.svg')); ?>" alt="edit" loading="lazy" />
                                            </button>
                                        </div>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-center" colspan="100%"><?php echo e(__('No Data Found')); ?></td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="my-3">
            <?php echo e($socialLinks->withQueryString()->links()); ?>

        </div>

    </div>

    <!--=== update Modal ===-->
    <form action="" id="updateColor" method="POST">
        <?php echo csrf_field(); ?>
        <div class="modal fade" id="updateBrand" tabindex="-1">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">
                            <?php echo e(__('Update Social Link')); ?>

                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">

                        <div class="mb-3">
                            <label for="updateName" class="form-label">
                                <?php echo e(__('Name')); ?>

                            </label>
                            <input type="text" class="form-control" id="updateName" name="name" required
                                value="" readonly />
                        </div>

                        <div class="mb-3">
                            <label for="updateLink" class="form-label">
                                <?php echo e(__('Social Link')); ?>

                            </label>
                            <input type="text" class="form-control" id="updateLink" name="link" value="" />
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">
                            <?php echo e(__('Update Link')); ?>

                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
    <style>
        .social-icon {
            display: flex;
            justify-content: center;
            align-items: center;
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background: #fff;
            border: 1px solid #f3f4f6;
        }
        .social-icon img {
            width: 24px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        const openColorUpdateModal = (socialLink) => {

            $("#updateName").val(socialLink.name);
            $("#updateLink").val(socialLink.link);
            $("#updateColor").attr('action', `<?php echo e(route('admin.socialLink.update', ':id')); ?>`.replace(':id', socialLink
                .id));

            $("#updateBrand").modal('show');
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home4/righthir/righthire.co.in/resources/views/admin/social-link/index.blade.php ENDPATH**/ ?>