<?php $__env->startSection('header-title', __('Product List')); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex align-items-center flex-wrap gap-3 justify-content-between px-3 pb-3">
        <h4 class="mb-0">
            <?php echo e(__('Product List')); ?>

        </h4>
        <div class="d-flex align-items-center gap-2">
            <div class="mt-2 mt-lg-0 d-flex gap-2 justify-content-end">
                <a href=" <?php echo e(route('shop.product.index', ['view_type' => 'grid'])); ?>"
                    class="btn <?php echo e(request('view_type') == 'list' ? 'btn-secondary' : 'btn-primary'); ?>"><i
                        class="bi bi-grid"></i></a>
                <a href=" <?php echo e(route('shop.product.index', ['view_type' => 'list'])); ?>"
                    class="btn  <?php echo e(request('view_type') == 'list' ? 'btn-primary' : 'btn-secondary'); ?>"><i
                        class="bi bi-list-ul"></i></a>
            </div>
            <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'shop.product.create')): ?>
                <div class="custom-dropdown">
                    <button class="custom-dropdown-btn" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fa fa-plus-circle me-2"></i>
                        <?php echo e(__('Add Product')); ?>

                    </button>
                    <ul class="custom-dropdown-menu dropdown-menu">
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('shop.product.create')); ?>">
                                <i class="fa-solid fa-square-plus me-1"></i>
                                <?php echo e(__('Add Product')); ?>

                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('shop.digital.product.create')); ?>">
                                <i class="fa-solid fa-square-plus me-1"></i>
                                <?php echo e(__('Add Digital Product')); ?>

                            </a>
                        </li>
                    </ul>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="container-fluid">
        <!-- Flash Deal Alert -->
        <?php if($flashSale): ?>
            <div>
                <div class="alert flash-deal-alert d-flex justify-content-between align-items-center flex-wrap gap-3">
                    <div class="d-flex flex-column">
                        <div class="deal-text"><?php echo e($flashSale->name); ?></div>
                        <div class="deal-title"><?php echo e(__('Coming Soon')); ?></div>
                    </div>
                    <div class="countdown d-flex align-items-center">
                        <!-- Days -->
                        <div class="countdown-section">
                            <div class="countdown-label"><?php echo e(__('Days')); ?></div>
                            <div id="days" class="countdown-time">00</div>
                        </div>
                        <!-- Hours -->
                        <div class="countdown-section">
                            <div class="countdown-label"><?php echo e(__('Hours')); ?></div>
                            <div id="hours" class="countdown-time">00</div>
                        </div>
                        <!-- Minutes -->
                        <div class="countdown-section">
                            <div class="countdown-label"><?php echo e(__('Minutes')); ?></div>
                            <div id="minutes" class="countdown-time">00</div>
                        </div>
                        <!-- Seconds -->
                        <div class="countdown-section">
                            <div class="countdown-label"><?php echo e(__('Seconds')); ?></div>
                            <div id="seconds" class="countdown-time">00</div>
                        </div>
                    </div>
                    <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'shop.flashSale.show')): ?>
                        <a href="<?php echo e(route('shop.flashSale.show', $flashSale->id)); ?>" class="btn btn-primary py-2.5 addBtn">
                            Add Product
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
        <!-- End Flash Deal Alert -->

        <!-- Filter Product Modal -->
        <form action="" method="GET">
            <div class="modal fade" id="filterProductModal" tabindex="-1" aria-labelledby="filterProductModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="filterProductModalLabel"><?php echo e(__('Filter Products')); ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <div>
                                <?php if (isset($component)) { $__componentOriginalbf566fc26595b9cc6779e170beef8a5a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbf566fc26595b9cc6779e170beef8a5a = $attributes; } ?>
<?php $component = App\View\Components\Select::resolve(['label' => 'Category','name' => 'category','placeholder' => 'Select Category'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('select'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Select::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                                    <option value="">
                                        <?php echo e(__('Select Category')); ?>

                                    </option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>"
                                            <?php echo e(request('category') == $category->id ? 'selected' : ''); ?>>
                                            <?php echo e($category->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbf566fc26595b9cc6779e170beef8a5a)): ?>
<?php $attributes = $__attributesOriginalbf566fc26595b9cc6779e170beef8a5a; ?>
<?php unset($__attributesOriginalbf566fc26595b9cc6779e170beef8a5a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbf566fc26595b9cc6779e170beef8a5a)): ?>
<?php $component = $__componentOriginalbf566fc26595b9cc6779e170beef8a5a; ?>
<?php unset($__componentOriginalbf566fc26595b9cc6779e170beef8a5a); ?>
<?php endif; ?>
                                <input type="hidden" name="view_type" value="<?php echo e(request('view_type')); ?>">
                            </div>

                            <div class="mt-3">
                                <?php if (isset($component)) { $__componentOriginalbf566fc26595b9cc6779e170beef8a5a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbf566fc26595b9cc6779e170beef8a5a = $attributes; } ?>
<?php $component = App\View\Components\Select::resolve(['label' => 'Brand','name' => 'brand','placeholder' => 'All Brand'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('select'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Select::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                                    <option value="">
                                        <?php echo e(__('All Brand')); ?>

                                    </option>
                                    <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($brand->id); ?>"
                                            <?php echo e(request('brand') == $brand->id ? 'selected' : ''); ?>>
                                            <?php echo e($brand->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbf566fc26595b9cc6779e170beef8a5a)): ?>
<?php $attributes = $__attributesOriginalbf566fc26595b9cc6779e170beef8a5a; ?>
<?php unset($__attributesOriginalbf566fc26595b9cc6779e170beef8a5a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbf566fc26595b9cc6779e170beef8a5a)): ?>
<?php $component = $__componentOriginalbf566fc26595b9cc6779e170beef8a5a; ?>
<?php unset($__componentOriginalbf566fc26595b9cc6779e170beef8a5a); ?>
<?php endif; ?>
                            </div>

                            <div class="mt-3">
                                <?php if (isset($component)) { $__componentOriginalbf566fc26595b9cc6779e170beef8a5a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbf566fc26595b9cc6779e170beef8a5a = $attributes; } ?>
<?php $component = App\View\Components\Select::resolve(['label' => 'Color','name' => 'color','placeholder' => 'All Color'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('select'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Select::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                                    <option value="">
                                        <?php echo e(__('All Color')); ?>

                                    </option>
                                    <?php $__currentLoopData = $colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($color->id); ?>"
                                            <?php echo e(request('color') == $color->id ? 'selected' : ''); ?>>
                                            <?php echo e($color->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbf566fc26595b9cc6779e170beef8a5a)): ?>
<?php $attributes = $__attributesOriginalbf566fc26595b9cc6779e170beef8a5a; ?>
<?php unset($__attributesOriginalbf566fc26595b9cc6779e170beef8a5a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbf566fc26595b9cc6779e170beef8a5a)): ?>
<?php $component = $__componentOriginalbf566fc26595b9cc6779e170beef8a5a; ?>
<?php unset($__componentOriginalbf566fc26595b9cc6779e170beef8a5a); ?>
<?php endif; ?>
                            </div>
                        </div>
                        <div class=" modal-footer d-flex justify-content-between flex-wrap gap-2">
                            <a href="<?php echo e(route('shop.product.index')); ?>" class="btn btn-light py-2 px-4">
                                <?php echo e(__('Reset')); ?>

                            </a>

                            <button type="submit" class="btn btn-primary">
                                <?php echo e(__('Apply Filters')); ?>

                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
        <!-- End Filter Product Modal -->

        <div class="mb-3 card">
            <div class="card-body">
                <form action=""
                    class="d-flex align-items-center justify-content-end gap-3 mb-3 border-bottom pb-3 flex-wrap">
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                        data-bs-target="#filterProductModal">
                        <?php echo e(__('Filter')); ?>

                    </button>

                    <div class="input-group" style="max-width: 400px">
                        <input type="text" name="search" class="form-control"
                            placeholder="<?php echo e(__('Search by product name')); ?>" value="<?php echo e(request('search')); ?>">
                        <input type="hidden" name="view_type" value="<?php echo e(request('view_type')); ?>">
                        <button type="submit" class="input-group-text btn btn-primary">
                            <i class="fa fa-search"></i> <?php echo e(__('Search')); ?>

                        </button>
                    </div>
                </form>

                <?php if(request('view_type') == 'list'): ?>
                    <?php echo $__env->make('shop.product.listView', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                <?php else: ?>
                    <?php echo $__env->make('shop.product.gridView', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                <?php endif; ?>
            </div>
        </div>

        <div class="my-3">
            <?php echo e($products->links()); ?>

        </div>

    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        $(".confirmApprove").on("click", function(e) {
            e.preventDefault();
            const url = $(this).attr("href");
            Swal.fire({
                title: "Are you sure?",
                text: "You want to approve this product",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, Approve it!",
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = url;
                }
            });
        });
    </script>

    <?php if($flashSale): ?>
        <script>
            // Set the start and end date/time
            var startDateAndTime = "<?php echo e($flashSale->start_date); ?>T<?php echo e($flashSale->start_time); ?>";
            var endDateAndTime = "<?php echo e($flashSale->end_date); ?>T<?php echo e($flashSale->end_time); ?>";
            let startDate = new Date(startDateAndTime).getTime();
            let endDate = new Date(endDateAndTime).getTime();

            // Update the countdown every 1 second
            let countdownInterval = setInterval(() => {
                let now = new Date().getTime();

                // If current time is before the start date, show "Deal Coming" message
                if (now < startDate) {
                    let distanceToStart = startDate - now;

                    // Time calculations for days, hours, minutes, and seconds
                    let days = Math.floor(distanceToStart / (1000 * 60 * 60 * 24));
                    let hours = Math.floor((distanceToStart % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                    let minutes = Math.floor((distanceToStart % (1000 * 60 * 60)) / (1000 * 60));
                    let seconds = Math.floor((distanceToStart % (1000 * 60)) / 1000);

                    // Display the countdown with a "Deal Coming" message
                    document.getElementById("days").innerHTML = String(days).padStart(2, '0');
                    document.getElementById("hours").innerHTML = String(hours).padStart(2, '0');
                    document.getElementById("minutes").innerHTML = String(minutes).padStart(2, '0');
                    document.getElementById("seconds").innerHTML = String(seconds).padStart(2, '0');
                    return;
                }

                // Once the current time is after the start date and before the end date, show the active countdown
                let distance = endDate - now;

                // If the deal has ended, stop the countdown and show the message
                if (distance < 0) {
                    clearInterval(countdownInterval);
                    document.getElementById("days").innerHTML = "00";
                    document.getElementById("hours").innerHTML = "00";
                    document.getElementById("minutes").innerHTML = "00";
                    document.getElementById("seconds").innerHTML = "00";
                    document.querySelector(".deal-text").innerHTML = "Deal Ended!";
                    return;
                }

                // Time calculations for days, hours, minutes, and seconds
                let days = Math.floor(distance / (1000 * 60 * 60 * 24));
                let hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                let minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                let seconds = Math.floor((distance % (1000 * 60)) / 1000);

                // Display the result
                document.getElementById("days").innerHTML = String(days).padStart(2, '0');
                document.getElementById("hours").innerHTML = String(hours).padStart(2, '0');
                document.getElementById("minutes").innerHTML = String(minutes).padStart(2, '0');
                document.getElementById("seconds").innerHTML = String(seconds).padStart(2, '0');
            }, 1000);
        </script>
    <?php endif; ?>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?>
    <style>
        /* Flash Deal Alert Styles */
        .flash-deal-alert {
            background: url("<?php echo e(asset('assets/images/flash-sale.png')); ?>");
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            border-radius: 8px;
            color: white;
            border-radius: 8px;
            padding: 16px 32px;
        }

        .deal-title,
        .deal-text {
            font-size: 24px;
            font-weight: 600;
            color: white;
            margin: 0;
            line-height: 32px;
        }

        /* Countdown Timer Styles */
        .countdown {
            display: flex;
            gap: 8px;
            flex-wrap: wrap;
            justify-content: center;
            align-items: center;
        }

        .countdown-section {
            text-align: center;
            padding: 4px 8px;
            border-radius: 8px;
            background-color: white;
            min-width: 68px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }

        .countdown-label {
            font-size: 12px;
            color: #000;
        }

        .countdown-time {
            font-size: 20px;
            font-weight: bold;
            color: var(--theme-color);
        }

        .addBtn {
            border-radius: 25px;
            padding: 10px 20px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home4/righthir/righthire.co.in/resources/views/shop/product/index.blade.php ENDPATH**/ ?>