<?php $__env->startSection('header-title', __('Pages')); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid mb-3">

        <div class="d-flex justify-content-between align-items-center flex-wrap gap-2">

            <h4 class="m-0"><?php echo e(__('All Pages')); ?></h4>

            <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.page.create')): ?>
                <a href="<?php echo e(route('admin.page.create')); ?>" class="btn py-2.5 btn-primary">
                    <i class="fa fa-plus-circle"></i>
                    <?php echo e(__('Add Page')); ?>

                </a>
            <?php endif; ?>
        </div>

        <div class="card mt-3">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th scope="col"><?php echo e(__('Name')); ?></th>
                                <th scope="col"><?php echo e(__('URL')); ?></th>
                                <th scope="col"><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(__($page->title)); ?></td>
                                    <td class="text-muted">
                                        <?php echo e($page->url); ?>

                                    </td>
                                    <td>
                                        <div class="d-flex gap-2">
                                            <?php if(!$page->is_editable && $page->is_default): ?>
                                                <small class="text-black-50 fst-italic"><?php echo e(__('No action')); ?></small>
                                            <?php else: ?>
                                                <a href="<?php echo e(route('admin.page.edit', $page->id)); ?>"
                                                    class="btn circleIcon btn-outline-info btn-sm">
                                                    <img src="<?php echo e(asset('assets/icons-admin/edit.svg')); ?>" alt="edit"
                                                        loading="lazy" />
                                                </a>
                                                <?php if($page->is_editable): ?>
                                                    <a href="<?php echo e(route('admin.page.show', $page->id)); ?>"
                                                        class="btn circleIcon btn-outline-primary btn-sm">
                                                        <img src="<?php echo e(asset('assets/icons-admin/eye.svg')); ?>" alt="view"
                                                            loading="lazy" />
                                                    </a>
                                                <?php endif; ?>
                                                <?php if(!$page->is_default): ?>
                                                    <a href="<?php echo e(route('admin.page.destroy', $page->id)); ?>"
                                                        class="btn circleIcon btn-outline-danger deleteConfirm btn-sm">
                                                        <img src="<?php echo e(asset('assets/icons-admin/trash.svg')); ?>"
                                                            alt="delete" loading="lazy" />
                                                    </a>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home4/righthir/righthire.co.in/resources/views/admin/pages/index.blade.php ENDPATH**/ ?>