<?php $__env->startSection('header-title', __('Languages')); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid my-4">
        <div class="row">
            <div class="col-xl-8 col-lg-9 mt-2 mx-auto ">
                <div class="card border-0 rounded shadow-sm">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h3 class="m-0"><?php echo e(__('Languages')); ?></h3>

                        <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.language.create')): ?>
                            <a class="btn btn-primary" href="<?php echo e(route('admin.language.create')); ?>">
                                <i class="fa fa-plus-circle" aria-hidden="true"></i>
                                <?php echo e(__('Add Language')); ?>

                            </a>
                        <?php endif; ?>
                    </div>
                </div>

                <?php $__currentLoopData = $allLanguages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="language-item shadow-sm">
                        <div class="d-flex gap-2 flex-wrap">
                            <div style="min-width: 160px">
                                <small class="text-black-50 d-block fst-italic" style="line-height: 0.7;">
                                    <?php echo e(__('Title')); ?>

                                </small>
                                <strong class="fs-6"><?php echo e($language->title); ?></strong>
                            </div>

                            <div>
                                <small class="text-black-50 d-block fst-italic" style="line-height: 0.7;">
                                    <?php echo e(__('Name')); ?>

                                </small>
                                <strong><?php echo e($language->name); ?></strong>
                            </div>
                        </div>
                        <div>
                            <?php if($language->name == config('app.locale')): ?>
                                <span class="badge bg-light text-black"><?php echo e(__('Default')); ?></span>
                            <?php else: ?>
                                <a href="<?php echo e(route('admin.language.setDefault', $language->id)); ?>" class="circleIcon btn btn-outline-warning btn-sm" title="<?php echo e(__('Set Default')); ?>">
                                    <img src="<?php echo e(asset('assets/icons-admin/language-2.svg')); ?>" alt="default" loading="lazy" />
                                </a>
                            <?php endif; ?>
                            <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.language.edit')): ?>
                                <a href="<?php echo e(route('admin.language.edit', $language->id)); ?>" class="circleIcon btn btn-outline-info btn-sm">
                                    <img src="<?php echo e(asset('assets/icons-admin/edit.svg')); ?>" alt="edit" loading="lazy" />
                                </a>
                            <?php endif; ?>
                            <?php if($language->name != 'en'): ?>
                                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.language.destroy')): ?>
                                    <a class="delete-confirm btn circleIcon btn-outline-danger btn-sm"
                                        href="<?php echo e(route('admin.language.delete', $language->id)); ?>">
                                        <img src="<?php echo e(asset('assets/icons-admin/trash.svg')); ?>" alt="trash" loading="lazy">
                                    </a>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        $('.delete-confirm').on('click', function(e) {
            e.preventDefault();
            const url = $(this).attr('href');
            Swal.fire({
                title: "<?php echo e(__('Are you sure?')); ?>",
                text: "<?php echo e(__('You will not be able to revert this!')); ?>",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#00B894',
                cancelButtonColor: '#d33',
                confirmButtonText: "<?php echo e(__('Yes, delete it!')); ?>",
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = url;
                }
            })
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home4/righthir/righthire.co.in/resources/views/admin/language/index.blade.php ENDPATH**/ ?>