<?php $__env->startSection('header-title', __('Categories')); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex align-items-center flex-wrap gap-3 justify-content-between px-3">

        <h4>
            <?php echo e(__('Category List')); ?>

        </h4>

        <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.category.create')): ?>
        <a href="<?php echo e(route('admin.category.create')); ?>" class="btn py-2 btn-primary">
            <i class="fa fa-plus-circle"></i>
            <?php echo e(__('Add Category')); ?>

        </a>
        <?php endif; ?>
    </div>

    <div class="container-fluid mt-3">

        <div class="mb-3 card">
            <div class="card-body">
                <div class="cardTitleBox">
                    <h5 class="card-title chartTitle">
                        <?php echo e(__('Categories')); ?>

                    </h5>
                </div>
                <div class="table-responsive">
                    <table class="table border-left-right table-responsive-md">
                        <thead>
                            <tr>
                                <th class="text-center"><?php echo e(__('SL')); ?></th>
                                <th><?php echo e(__('Thumbnail')); ?></th>
                                <th><?php echo e(__('Name')); ?></th>
                                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.category.toggle')): ?>
                                <th><?php echo e(__('Status')); ?></th>
                                <?php endif; ?>
                                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.category.edit')): ?>
                                <th class="text-center"><?php echo e(__('Action')); ?></th>
                                <?php endif; ?>
                            </tr>
                        </thead>
                        <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $serial = $categories->firstItem() + $key;
                            ?>
                            <tr>
                                <td class="text-center"><?php echo e($serial); ?></td>

                                <td>
                                    <img src="<?php echo e($category->thumbnail); ?>" width="50">
                                </td>

                                <td><?php echo e($category->name); ?></td>

                                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.category.toggle')): ?>
                                <td>
                                    <label class="switch mb-0">
                                        <a href="<?php echo e(route('admin.category.toggle', $category->id)); ?>">
                                            <input type="checkbox" <?php echo e($category->status ? 'checked' : ''); ?>>
                                            <span class="slider round"></span>
                                        </a>
                                    </label>
                                </td>
                                <?php endif; ?>
                                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.category.edit')): ?>
                                <td class="text-center">
                                    <div class="d-flex gap-3 justify-content-center">
                                        <a href="<?php echo e(route('admin.category.edit', $category->id)); ?>" class="btn btn-outline-primary circleIcon">
                                            <img src="<?php echo e(asset('assets/icons-admin/edit.svg')); ?>" alt="edit" loading="lazy" />
                                        </a>
                                    </div>
                                </td>
                                <?php endif; ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-center" colspan="100%"><?php echo e(__('No Data Found')); ?></td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="my-3">
            <?php echo e($categories->withQueryString()->links()); ?>

        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home4/righthir/righthire.co.in/resources/views/admin/category/index.blade.php ENDPATH**/ ?>