<?php $__env->startSection('header-title', __('Delivery Charges')); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex align-items-center flex-wrap gap-3 justify-content-between px-3">
        <h4><?php echo e(__('Manage Delivery Charge')); ?></h4>

        <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.deliveryCharge.create')): ?>
        <a href="<?php echo e(route('admin.deliveryCharge.create')); ?>" class="btn py-2 btn-primary">
            <i class="fa fa-plus-circle"></i>
            <?php echo e(__('Add Delivery Charge')); ?>

        </a>
        <?php endif; ?>
    </div>

    <div class="container-fluid mt-3">

        <div class="my-3 card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table border-left-right table-responsive-lg">
                        <thead>
                            <tr>
                                <th><?php echo e(__('SL')); ?></th>
                                <th class="text-center"><?php echo e(__('Min. Order QTY')); ?></th>
                                <th class="text-center"><?php echo e(__('Max. Order QTY')); ?></th>
                                <th class="text-center"><?php echo e(__('Charge')); ?></th>
                                <th class="text-center"><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                        <?php $__empty_1 = true; $__currentLoopData = $deliveryCharges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deliveryCharge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <?php echo e($loop->iteration); ?>.
                                </td>

                                <td class="text-center"><?php echo e($deliveryCharge->min_qty); ?></td>
                                <td class="text-center"><?php echo e($deliveryCharge->max_qty); ?></td>
                                <td class="text-center"><?php echo e(showCurrency($deliveryCharge->charge)); ?></td>

                                <td class="text-center">
                                    <div class="d-flex gap-2 justify-content-center">
                                        <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.deliveryCharge.edit')): ?>
                                            <a href="<?php echo e(route('admin.deliveryCharge.edit', $deliveryCharge->id)); ?>" class="btn btn-outline-info btn-sm circleIcon">
                                                <img src="<?php echo e(asset('assets/icons-admin/edit.svg')); ?>" alt="edit" loading="lazy" />
                                            </a>
                                        <?php endif; ?>
                                        <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.deliveryCharge.destroy')): ?>
                                            <a href="<?php echo e(route('admin.deliveryCharge.destroy', $deliveryCharge->id)); ?>" class="btn btn-outline-danger btn-sm deleteConfirm circleIcon">
                                                <img src="<?php echo e(asset('assets/icons-admin/trash.svg')); ?>" alt="delete" loading="lazy" />
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-center" colspan="100%"><?php echo e(__('No Data Found')); ?></td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="my-3">
            <?php echo e($deliveryCharges->links()); ?>

        </div>

    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home4/righthir/righthire.co.in/resources/views/admin/delivery-charge/index.blade.php ENDPATH**/ ?>