<?php $__env->startSection('header-title', __('All Help Requests')); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex justify-content-between align-items-center gap-2 flex-wrap mb-3">
        <h4>
            <?php echo e(__('All Help Requests')); ?>

        </h4>

        <div>
            <span class="text-muted">
                <?php echo e(__('Short By')); ?>:</span>
            <div class="dropdown">
                <a class="btn btn-secondary btn-sm dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown"
                    aria-expanded="false" style="min-width: 80px">
                    <?php echo e(__(request()->status ?? 'All')); ?>

                </a>

                <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="<?php echo e(route('admin.supportTicket.index')); ?>"><?php echo e(__('All')); ?></a>
                    </li>
                    <li><a class="dropdown-item"
                            href="<?php echo e(route('admin.supportTicket.index', 'status=pending')); ?>"><?php echo e(__('Pending')); ?></a></li>
                    <li><a class="dropdown-item"
                            href="<?php echo e(route('admin.supportTicket.index', 'status=confirm')); ?>"><?php echo e(__('Confirm')); ?></a></li>
                    <li><a class="dropdown-item"
                            href="<?php echo e(route('admin.supportTicket.index', 'status=completed')); ?>"><?php echo e(__('Completed')); ?></a>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body d-flex flex-column gap-3">
            <?php $__empty_1 = true; $__currentLoopData = $supportTickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supportTicket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="ticket card">
                    <div class="card-body">
                        <!---- header -->
                        <div class="d-flex justify-content-between gap-2 flex-wrap border-bottom pb-2">
                            <span class="text-muted">
                                <?php echo e($supportTicket->created_at->format('d F, Y')); ?>

                            </span>
                            <div class="d-flex gap-2 align-items-center">
                                <span class="ticket-number">#<?php echo e($supportTicket->ticket_number); ?></span>
                                <span class="ticket-status <?php echo e($supportTicket->status); ?>">
                                    <?php echo e($supportTicket->status); ?>

                                </span>
                            </div>
                        </div>

                        <!---- content -->

                        <a href="<?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.supportTicket.show')): ?>
<?php echo e(route('admin.supportTicket.show', $supportTicket->id)); ?>

<?php else: ?>
'#'
<?php endif; ?>"
                            class="d-flex justify-content-between align-items-center gap-2 flex-wrap pt-2">
                            <div class="ticket-item">
                                <div class="text-muted"><?php echo e(__('Order Number')); ?></div>
                                <div><?php echo e($supportTicket->order_number ?? __('N/A')); ?></div>
                            </div>

                            <div class="ticket-item">
                                <div class="text-muted"><?php echo e(__('Issue Type')); ?></div>
                                <div class="ticket-type"><?php echo e(__($supportTicket->issue_type)); ?></div>
                            </div>

                            <div class="ticket-item">
                                <div class="text-muted"><?php echo e(__('Subject')); ?></div>
                                <div class="ticket-subject"><?php echo e(__($supportTicket->subject)); ?></div>
                            </div>

                            <div class="icon">
                                <i class="bi bi-chevron-right"></i>
                            </div>
                        </a>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <p>
                    <?php echo e(__('No Help Requests Found!')); ?>

                </p>
            <?php endif; ?>
        </div>
    </div>

    <div class="py-3">
        <?php echo e($supportTickets->withQueryString()->links()); ?>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home4/righthir/righthire.co.in/resources/views/admin/supportTicket/index.blade.php ENDPATH**/ ?>