<?php $__env->startSection('header-title', __('Flash Sales')); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex align-items-center flex-wrap gap-3 justify-content-between px-3">
        <h4 class="mb-0">
            <?php echo e(__('Flash Sales')); ?>

        </h4>

        <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.flashSale.create')): ?>
            <a href="<?php echo e(route('admin.flashSale.create')); ?>" class="btn py-2.5 btn-primary">
                <i class="fa fa-plus-circle"></i>
                <?php echo e(__('Add Flash Sale')); ?>

            </a>
        <?php endif; ?>
    </div>

    <div class="container-fluid mt-3">

        <div class="mb-3 card">
            <div class="card-body">

                <div class="table-responsive">
                    <table class="table border-left-right table-responsive-lg">
                        <thead>
                            <tr>
                                <th class="text-center"><?php echo e(__('SL')); ?></th>
                                <th><?php echo e(__('Thumbnail')); ?></th>
                                <th><?php echo e(__('Name')); ?></th>
                                <th><?php echo e(__('Start Date')); ?></th>
                                <th><?php echo e(__('End Date')); ?></th>
                                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'shop.flashSale.toggle')): ?>
                                    <th class="text-center"><?php echo e(__('Status')); ?></th>
                                <?php endif; ?>
                                <th style="max-width: 250px"><?php echo e(__('Description')); ?></th>
                                <th class="text-center"><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                        <?php $__empty_1 = true; $__currentLoopData = $flashSales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $flashSale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td class="text-center"><?php echo e(++$key); ?></td>

                                <td>
                                    <div class="product-image" style="width: 90px; height: 76px">
                                        <img src="<?php echo e($flashSale->thumbnail); ?>" alt="thumbnail" style="width: 100%; height: 100%" loading="lazy"/>
                                    </div>
                                </td>

                                <td><?php echo e($flashSale->name); ?></td>

                                <td><?php echo e($flashSale->start_date . ' - ' . $flashSale->start_time); ?></td>
                                <td><?php echo e($flashSale->end_date . ' - ' . $flashSale->end_time); ?></td>

                                <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.flashSale.toggle')): ?>
                                    <td class="text-center">
                                        <label class="switch mb-0" data-bs-toggle="tooltip" data-bs-placement="left"
                                            data-bs-title="<?php echo e(__('Update Publish Status')); ?>">
                                            <a href="<?php echo e(route('admin.flashSale.toggle', $flashSale->id)); ?>">
                                                <input type="checkbox" <?php echo e($flashSale->status ? 'checked' : ''); ?>>
                                                <span class="slider round"></span>
                                            </a>
                                        </label>
                                    </td>
                                <?php endif; ?>

                                <td style="max-width: 250px">
                                    <?php echo e($flashSale->description ?? '--'); ?>

                                </td>

                                <td class="text-center">
                                    <div class="d-flex gap-2 justify-content-center">
                                        <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.flashSale.product')): ?>
                                            <a href="<?php echo e(route('admin.flashSale.product', $flashSale->id)); ?>"
                                                class="btn svg-bg circleIcon" data-bs-toggle="tooltip"
                                                data-bs-placement="left" data-bs-title="<?php echo e(__('View Product')); ?>">
                                                <img src="<?php echo e(asset('assets/icons-admin/eye.svg')); ?>" alt="view" loading="lazy" />
                                            </a>
                                        <?php endif; ?>

                                        <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.flashSale.edit')): ?>
                                            <a href="<?php echo e(route('admin.flashSale.edit', $flashSale->id)); ?>"
                                                class="btn btn-outline-info circleIcon" data-bs-toggle="tooltip"
                                                data-bs-placement="left" data-bs-title="<?php echo e(__('Edit')); ?>">
                                                <img src="<?php echo e(asset('assets/icons-admin/edit.svg')); ?>" alt="edit" loading="lazy" />
                                            </a>
                                        <?php endif; ?>

                                        <?php if (\Illuminate\Support\Facades\Blade::check('hasPermission', 'admin.flashSale.destroy')): ?>
                                            <a href="<?php echo e(route('admin.flashSale.destroy', $flashSale->id)); ?>"
                                                class="btn btn-outline-danger circleIcon deleteConfirm" data-bs-toggle="tooltip"
                                                data-bs-placement="left" data-bs-title="<?php echo e(__('Delete')); ?>">
                                                <img src="<?php echo e(asset('assets/icons-admin/trash.svg')); ?>" alt="delete" loading="lazy" />
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-center" colspan="100%"><?php echo e(__('No Data Found')); ?></td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="my-3">
            <?php echo e($flashSales->links()); ?>

        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home4/righthir/righthire.co.in/resources/views/admin/flashSale/index.blade.php ENDPATH**/ ?>