<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\BeyondCorp;

class GoogleCloudBeyondcorpSecuritygatewaysV1SecurityGateway extends \Google\Collection
{
  protected $collection_key = 'externalIps';
  /**
   * @var string
   */
  public $createTime;
  /**
   * @var string
   */
  public $delegatingServiceAccount;
  /**
   * @var string
   */
  public $displayName;
  /**
   * @var string[]
   */
  public $externalIps;
  protected $hubsType = GoogleCloudBeyondcorpSecuritygatewaysV1Hub::class;
  protected $hubsDataType = 'map';
  /**
   * @var string
   */
  public $name;
  protected $proxyProtocolConfigType = GoogleCloudBeyondcorpSecuritygatewaysV1ProxyProtocolConfig::class;
  protected $proxyProtocolConfigDataType = '';
  protected $serviceDiscoveryType = GoogleCloudBeyondcorpSecuritygatewaysV1ServiceDiscovery::class;
  protected $serviceDiscoveryDataType = '';
  /**
   * @var string
   */
  public $state;
  /**
   * @var string
   */
  public $updateTime;

  /**
   * @param string
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * @param string
   */
  public function setDelegatingServiceAccount($delegatingServiceAccount)
  {
    $this->delegatingServiceAccount = $delegatingServiceAccount;
  }
  /**
   * @return string
   */
  public function getDelegatingServiceAccount()
  {
    return $this->delegatingServiceAccount;
  }
  /**
   * @param string
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * @param string[]
   */
  public function setExternalIps($externalIps)
  {
    $this->externalIps = $externalIps;
  }
  /**
   * @return string[]
   */
  public function getExternalIps()
  {
    return $this->externalIps;
  }
  /**
   * @param GoogleCloudBeyondcorpSecuritygatewaysV1Hub[]
   */
  public function setHubs($hubs)
  {
    $this->hubs = $hubs;
  }
  /**
   * @return GoogleCloudBeyondcorpSecuritygatewaysV1Hub[]
   */
  public function getHubs()
  {
    return $this->hubs;
  }
  /**
   * @param string
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param GoogleCloudBeyondcorpSecuritygatewaysV1ProxyProtocolConfig
   */
  public function setProxyProtocolConfig(GoogleCloudBeyondcorpSecuritygatewaysV1ProxyProtocolConfig $proxyProtocolConfig)
  {
    $this->proxyProtocolConfig = $proxyProtocolConfig;
  }
  /**
   * @return GoogleCloudBeyondcorpSecuritygatewaysV1ProxyProtocolConfig
   */
  public function getProxyProtocolConfig()
  {
    return $this->proxyProtocolConfig;
  }
  /**
   * @param GoogleCloudBeyondcorpSecuritygatewaysV1ServiceDiscovery
   */
  public function setServiceDiscovery(GoogleCloudBeyondcorpSecuritygatewaysV1ServiceDiscovery $serviceDiscovery)
  {
    $this->serviceDiscovery = $serviceDiscovery;
  }
  /**
   * @return GoogleCloudBeyondcorpSecuritygatewaysV1ServiceDiscovery
   */
  public function getServiceDiscovery()
  {
    return $this->serviceDiscovery;
  }
  /**
   * @param string
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return string
   */
  public function getState()
  {
    return $this->state;
  }
  /**
   * @param string
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudBeyondcorpSecuritygatewaysV1SecurityGateway::class, 'Google_Service_BeyondCorp_GoogleCloudBeyondcorpSecuritygatewaysV1SecurityGateway');
